package cz.cuni.amis.pogamut.emohawk.communication.stream;

import cz.cuni.amis.pogamut.emohawk.communication.worldView.worldObjectUpdater.replication.replica.iface.object.IObjectReplica;

/** Primitive Unreal type tools
 * 
 * Supports object reference too.
 * @author Paletz
 */
public class PrimitiveTools {
	
	/** Read primitive from stream
	 * 
	 * Picks the right method to read the primitive.
	 * 
	 * @param primitiveClass class of primitive to read
	 * @param stream input stream
	 * @return read primitive value
	 */
	@SuppressWarnings("unchecked")
	public static <Primitive> Primitive readPrimitive( Class<Primitive> primitiveClass, IObjectInputStream stream ) {
		if ( primitiveClass == Integer.class ) {
			return (Primitive) new Integer( stream.readInt() );
		} else if ( primitiveClass == Boolean.class ) {
			return (Primitive) new Boolean( stream.readBool() );
		} else if ( primitiveClass == String.class ) {
			return (Primitive) stream.readString();
		} else if ( primitiveClass == Float.class ) {
			return (Primitive) new Float( stream.readFloat() );
		} else if ( IObjectReplica.class.isAssignableFrom( primitiveClass ) ) {
			return (Primitive) stream.readObjectRef();
		} else {
			throw new AssertionError( "Unexpected primitive class "+primitiveClass );
		}
	}
	
	/** Check whether primitive is next in stream
	 * 
	 * @param primitiveClass class of primitive to read
	 * @param stream input stream
	 * @return true if primitive is next
	 */
	public static <Primitive> boolean hasPrimitive( Class<Primitive> primitiveClass, IObjectInputStream stream ) {
		if ( primitiveClass == Integer.class ) {
			return stream.tellNext() == PayloadType.PAYLOAD_TYPE_INT;
		} else if ( primitiveClass == Boolean.class ) {
			return stream.tellNext() == PayloadType.PAYLOAD_TYPE_BOOL;
		} else if ( primitiveClass == String.class ) {
			return stream.tellNext() == PayloadType.PAYLOAD_TYPE_STRING;
		} else if ( primitiveClass == Float.class ) {
			return stream.tellNext() == PayloadType.PAYLOAD_TYPE_FLOAT;
		} else if ( IObjectReplica.class.isAssignableFrom( primitiveClass ) ) {
			return stream.tellNext() == PayloadType.PAYLOAD_TYPE_OBJECT_REF && primitiveClass.isInstance( stream.peekObjectRef() );
		} else {
			throw new AssertionError( "Unexpected primitive class "+primitiveClass );
		}
	}
	
	
	/** Write primitive type to a stream
	 * 
	 * Picks the right method to write the primitive.
	 * 
	 * @param primitive value to write
	 * @param stream output stream
	 */
	public static void writePrimitive( Object primitive, IOutputStream stream ) {
		if ( primitive instanceof Integer ) {
			stream.writeInt( (Integer) primitive );
		} else if ( primitive instanceof Boolean ) {
			stream.writeBool( (Boolean) primitive );
		} else if ( primitive instanceof String ) {
			stream.writeString( (String) primitive );
		} else if ( primitive instanceof Float ) {
			stream.writeFloat( (Float) primitive );
		} else if ( primitive instanceof IObjectReplica ) {
			throw new AssertionError( "Object references not supported." );
		} else {
			throw new AssertionError( "Unexpected primitive class "+primitive.getClass() );
		}
	}
}
