package cz.cuni.amis.pogamut.emohawk.communication.stream;

/** Input stream capable of receiving encoded object references
 */
public interface IEncodedObjectInputStream extends IInputStream {

	/** Read object reference primitive
	 * 
	 * Results in error if next primitive is not an object reference. See also tellNext().
	 * 
	 * @return object
	 */
	int readObjectRef();

	/** Read object reference primitive but keep it in stream
	 * 
	 * Results in error if next primitive is not an object reference. See also tellNext().
	 * @return object
	 */
	int peekObjectRef();
}