package cz.cuni.amis.pogamut.emohawk.communication.stream;

import cz.cuni.amis.pogamut.emohawk.communication.worldView.worldObjectUpdater.replication.replica.iface.object.IObjectReplica;

/** Object decoder stream
 * 
 * 
 *  
 * @author Paletz
 */
public abstract class DecoderStream implements IObjectInputStream {

	protected IEncodedObjectInputStream encodedStream;
	
	public DecoderStream( IEncodedObjectInputStream encodedStream ) {
		this.encodedStream = encodedStream;
	}
		
	/** Decode object reference
	 * 
	 * @param objectReference encoded object reference
	 * @return referenced object
	 */
	protected abstract IObjectReplica decode( int objectReference );
	
	@Override
	public PayloadType tellNext() {
		return encodedStream.tellNext();
	}
	
	@Override
	public String readString() {
		return encodedStream.readString();
	}
	
	@Override
	public int readInt() {
		return encodedStream.readInt();
	}
	
	@Override
	public float readFloat() {
		return encodedStream.readFloat();
	}
	
	@Override
	public boolean readBool() {
		return encodedStream.readBool();
	}
	
	@Override
	public IObjectReplica readObjectRef() {
		return decodeOrNull( encodedStream.readObjectRef() );
	}

	@Override
	public IObjectReplica peekObjectRef() {
		return decodeOrNull( encodedStream.peekObjectRef() );
	}
	
	protected IObjectReplica decodeOrNull( int objectReference ) {
		if ( objectReference != -1 ) {
			return decode( objectReference );					
		} else {
			return null;
		}
		
	}
}