package cz.cuni.amis.pogamut.emohawk.communication.messages.replication;

import cz.cuni.amis.pogamut.base.communication.messages.InfoMessage;

/** Object has been replicated
 * 
 * Object value is sent separately. See {@link ObjectUpdate} event.
 * @author Paletz
 */
public class ObjectReplication extends InfoMessage implements IReplicationEvent {

	protected long simTime;
	protected int replicationIndex;
	protected String objectClass;
	
	public ObjectReplication() {
		simTime = 0;
	}	
	
	/** Get simTime
	 * 
	 * @return simTime
	 */
	public long getSimTime() {
		return simTime;
	}

	/** Get the replication index
	 * 
	 * @return the replication index	 
	 */
	public int getReplicationIndex() {
		return replicationIndex;
	}
	
	/** Get the Unreal script class
	 * 
	 * @return  the Unreal script class
	 */
	public String getObjectClass() {
		return objectClass;
	}
	
	/** Initialization from yylex
	 */
	protected void setSimTime( long value ) {
		simTime = value;
	}
	
	/** Initialization from yylex
	 */
	public void setReplicationIndex( int replicationIndex ) {
		this.replicationIndex = replicationIndex;
	}
	
	/** Initialization from yylex
	 */
	public void setObjectClass(String objectClass) {
		this.objectClass = objectClass;
	}
}
