package cz.cuni.amis.pogamut.emohawk.agent.sensomotoric.emoticon;

import java.util.HashMap;

/**
 * Bubbles that can be used as a background for emoticons
 *
 * @author Jimmy
 */
public enum EmoticonBubbleType {

	NONE("None", "null"),
    BUBBLE_EMOTIVE_SLIGHTLY_LEFT("bublina_emotivni_lehceleva_512", "BUBBLE_EMOTIVE_SLIGHTLY_LEFT"),
    BUBBLE_EMOTIVE_SLIGHTLY_RIGHT("bublina_emotivni_lehceprava_512", "BUBBLE_EMOTIVE_SLIGHTLY_RIGHT"),
    BUBBLE_EMOTIVE_LEFT("bublina_emotivni_leva_512", " BUBBLE_EMOTIVE_LEFT"),
    BUBBLE_EMOTIVE_RIGHT("bublina_emotivni_prava_512", "BUBBLE_EMOTIVE_RIGHT"),
    BUBBLE_EMOTIVE_CENTER("bublina_emotivni_stred_512", "BUBBLE_EMOTIVE_CENTER"),
    BUBBLE_THOUGHT_SLIGHTLY_LEFT("bublina_mysleni_lehceleva_512", "BUBBLE_THOUGHT_SLIGHTLY_LEFT"),
    BUBBLE_THOUGHT_SLIGHTLY_RIGHT("bublina_mysleni_lehceprava_512", "BUBBLE_THOUGHT_SLIGHTLY_RIGHT"),
    BUBBLE_THOUGHT_LEFT("bublina_mysleni_leva_512", "BUBBLE_THOUGHT_LEFT"),
    BUBBLE_THOUGHT_RIGHT("bublina_mysleni_prava_512", "BUBBLE_THOUGHT_RIGHT"),
    BUBBLE_THOUGHT_CENTER("bublina_mysleni_stred_512", "BUBBLE_THOUGHT_CENTER"),
    BUBBLE_NORMAL_SLIGHTLY_LEFT("bublina_normalni_lehceleva_512", "BUBBLE_NORMAL_SLIGHTLY_LEFT"),
    BUBBLE_NORMAL_SLIGHTLY_RIGHT("bublina_normalni_lehceprava_512", "BUBBLE_NORMAL_SLIGHTLY_RIGHT"),
    BUBBLE_NORMAL_LEFT("bublina_normalni_leva_512", "BUBBLE_NORMAL_LEFT"),
    BUBBLE_NORMAL_RIGHT("bublina_normalni_prava_512", "BUBBLE_NORMAL_RIGHT"),
    BUBBLE_NORMAL_CENTER("bublina_normalni_stred_512", "BUBBLE_NORMAL_CENTER");
    
    /** 
     * Id of the emoticon in Unreal 
     */
    String id;
    
    /** 
     * English name of the emoticon. 
     */
    String nameEN;

    /** 
     * Default constructor.
     */
    EmoticonBubbleType(String cId, String cNameEN) {
        id = cId;
        nameEN = cNameEN;        
    }
    
    //
    // STATIC
    //
    
    /** 
     * For faster translation of string bubble id to EmoticonBubbleType enum.
     */
    static HashMap<String, EmoticonBubbleType> bubblesMapping = new HashMap<String, EmoticonBubbleType>();
    
    static {
    	for (EmoticonBubbleType bubble : EmoticonBubbleType.values()) {
    		bubblesMapping.put(bubble.id, bubble);
    	}
    }
    
    /**
     * Return "bubble type" for it's ID.
     * 
     * @param id
     * @return
     */
    public static EmoticonBubbleType get(String id) {
    	return bubblesMapping.get(id);
    }
    
    /**
     * Whether we have this EmoticonBubbleType.
     * 
     * @param id
     * @return
     */
    public static boolean has(String id) {
    	return bubblesMapping.containsKey(id);
    }
	
}
