package cz.cuni.amis.pogamut.emohawk.agent.losChecker;

import cz.cuni.amis.pogamut.base3d.worldview.object.Location;

/** Line-of-sight report
 * 
 * @author Paletz
 */
public class LosReportEvent {
	
	protected Location location;
	protected boolean isInLos;
	
	/** Consturctor
	 * 
	 * @param location checked location
	 * @param isInLos true if location is line-of-sight
	 */
	public LosReportEvent( Location location, boolean isInLos ) {
		this.location = location;
		this.isInLos = isInLos;
	}
	
	/** Get checked location
	 *  
	 * @return checked location
	 */
	public Location getLocation() {
		return location;
	}
	
	/** Tell whether checked location is in line-of-sight
	 * 
	 * @return true if checked location is in line-of-sight
	 */
	public boolean isInLos() {
		return isInLos;
	}
}
