/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.emohawk.agent.module.stream;

import cz.cuni.amis.pogamut.emohawk.agent.module.stream.IInputStream;
import cz.cuni.amis.pogamut.emohawk.agent.module.stream.IOutputStream;
import cz.cuni.amis.pogamut.emohawk.communication.stream.PayloadType;
import java.util.LinkedList;

public class StreamBuffer
implements IInputStream,
IOutputStream {
    protected LinkedList<Object> data = new LinkedList();

    @Override
    public void writeInt(int value) {
        this.data.add(new Integer(value));
    }

    @Override
    public void writeFloat(float value) {
        this.data.add(new Float(value));
    }

    @Override
    public void writeBool(boolean value) {
        this.data.add(new Boolean(value));
    }

    @Override
    public void writeString(String value) {
        this.data.add(value);
    }

    @Override
    public PayloadType tellNext() {
        if (this.data.isEmpty()) {
            return PayloadType.PAYLOAD_TYPE_EOF;
        }
        return this.tellType(this.data.iterator().next());
    }

    @Override
    public int readInt() {
        return (Integer)this.data.pop();
    }

    @Override
    public float readFloat() {
        return ((Float)this.data.pop()).floatValue();
    }

    @Override
    public boolean readBool() {
        return (Boolean)this.data.pop();
    }

    @Override
    public String readString() {
        return (String)this.data.pop();
    }

    public void clear() {
        this.data.clear();
    }

    protected PayloadType tellType(Object payload) {
        if (payload instanceof Integer) {
            return PayloadType.PAYLOAD_TYPE_INT;
        }
        if (payload instanceof Float) {
            return PayloadType.PAYLOAD_TYPE_FLOAT;
        }
        if (payload instanceof Boolean) {
            return PayloadType.PAYLOAD_TYPE_BOOL;
        }
        if (payload instanceof String) {
            return PayloadType.PAYLOAD_TYPE_STRING;
        }
        throw new AssertionError((Object)"Unexpected value.");
    }
}

