/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.emohawk.agent.module.essence;

import cz.cuni.amis.pogamut.base.communication.worldview.object.IWorldObject;
import cz.cuni.amis.pogamut.base.communication.worldview.object.WorldObjectId;
import cz.cuni.amis.pogamut.base3d.worldview.IVisionWorldView;
import cz.cuni.amis.pogamut.emohawk.agent.module.essence.IEssenceMap;
import cz.cuni.amis.pogamut.emohawk.agent.module.replication.image.ControllerInfoReplica;
import cz.cuni.amis.pogamut.emohawk.agent.module.replication.image.PawnReplica;
import cz.cuni.amis.pogamut.emohawk.agent.module.replication.image.action.ActionRegistryReplica;
import cz.cuni.amis.pogamut.emohawk.agent.module.replication.image.essence.IEssenceReplica;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.Self;
import java.util.HashMap;
import java.util.Map;

public class EssenceMap
implements IEssenceMap {
    protected IVisionWorldView worldView;
    protected HashMap<String, PawnReplica> pawns;
    protected HashMap<String, ControllerInfoReplica> controllers;
    protected ActionRegistryReplica actionRegistry;
    protected HashMap<String, IEssenceReplica> essences;

    public EssenceMap(IVisionWorldView worldView) {
        this.worldView = worldView;
        this.pawns = new HashMap();
        this.controllers = new HashMap();
        this.essences = new HashMap();
    }

    public void associatePawn(String botId, PawnReplica pawn) {
        this.pawns.put(botId, pawn);
    }

    @Override
    public PawnReplica retrievePawn(String botId) {
        return this.pawns.get(botId);
    }

    @Override
    public PawnReplica retrievePawn(IWorldObject worldObject) {
        if (worldObject instanceof Self) {
            return this.retrievePawn(((Self)worldObject).getBotId().getStringId());
        }
        return this.retrievePawn(worldObject.getId().getStringId());
    }

    public void associateController(String botId, ControllerInfoReplica controller) {
        this.controllers.put(botId, controller);
    }

    @Override
    public ControllerInfoReplica retrieveController(String botId) {
        return this.controllers.get(botId);
    }

    @Override
    public ControllerInfoReplica retrieveController(IWorldObject worldObject) {
        return this.retrieveController(worldObject.getId().getStringId());
    }

    public void associateActionRegistry(ActionRegistryReplica actionRegistry) {
        this.actionRegistry = actionRegistry;
    }

    @Override
    public ActionRegistryReplica retrieveActionRegistry() {
        return this.actionRegistry;
    }

    public void associateEssence(String worldObjectId, IEssenceReplica essence) {
        this.essences.put(worldObjectId, essence);
    }

    @Override
    public IEssenceReplica retrieveEssence(String worldObjectId) {
        return this.essences.get(worldObjectId);
    }

    @Override
    public IEssenceReplica retrieveEssence(IWorldObject entity) {
        return this.retrieveEssence(entity.getId().getStringId());
    }

    @Override
    public <TEssence extends IEssenceReplica> Map<IWorldObject, TEssence> getAllVisible(Class<TEssence> essenceClass) {
        HashMap<IWorldObject, IEssenceReplica> retval = new HashMap<IWorldObject, IEssenceReplica>();
        for (Map.Entry entry : this.worldView.getVisible().entrySet()) {
            IWorldObject worldObject = this.worldView.get((WorldObjectId)entry.getKey());
            IEssenceReplica essence = this.retrieveEssence((IWorldObject)entry.getValue());
            if (essence == null) {
                essence = this.retrievePawn(worldObject);
            }
            if (essence == null || !essenceClass.isAssignableFrom(essence.getClass())) continue;
            IEssenceReplica castedEssence = essence;
            retval.put(worldObject, castedEssence);
        }
        return retval;
    }
}

