package cz.cuni.amis.pogamut.emohawk.communication.stream;

import cz.cuni.amis.pogamut.base.communication.messages.CommandMessage;

/** Data packet command.
 * 
 * Abstract base of all data packet commands.
 * 
 * @author Paletz
 *
 * @param <T> type of value in the packet
 */
public abstract class DataPacketCommand<T> extends CommandMessage {
	
	protected T value;
	
	public DataPacketCommand() {
	}	
		
	/** Get the value
	 * 
	 * @return the value	 
	 */
	public T getValue() {
		return value;
	}
	
	/** Set the value
	 * 
	 * @param value new value
	 */
	public void setValue( T value ) {
		this.value = value;
	}
	
	/** Convert to string
	 * 
	 * @return string representation that can be sent to gamebots
	 */
	public String toString() {
		StringBuilder buf = new StringBuilder();
		buf.append( getCommandName() );
		buf.append( " {Value ");
		buf.append( value );
		buf.append( "}");
		return buf.toString();
	}
	
	/** Get command name
	 * 
	 * Name used in the gamebot protocol.
	 * 
	 * @return command name
	 */
	abstract String getCommandName();
}
