package cz.cuni.amis.pogamut.emohawk.agent.module.replication.image.attribute.primitivelist;

import java.util.LinkedList;

import cz.cuni.amis.pogamut.emohawk.agent.module.replication.image.attribute.AbstractAttributeReplica;
import cz.cuni.amis.pogamut.emohawk.agent.module.replication.image.attribute.AttributeAccess;
import cz.cuni.amis.pogamut.emohawk.agent.module.replication.image.attribute.IAssignableAttributeReplica;
import cz.cuni.amis.pogamut.emohawk.agent.module.replication.image.ds.PrimitiveTools;
import cz.cuni.amis.pogamut.emohawk.agent.module.replication.image.ds.sll.SinglyLinkedListReplica;
import cz.cuni.amis.pogamut.emohawk.agent.module.replication.image.object.AbstractGenericObjectReplica;
import cz.cuni.amis.pogamut.emohawk.agent.module.replication.image.object.SpecializedClass;
import cz.cuni.amis.pogamut.emohawk.agent.module.stream.IInputObjectStream;
import cz.cuni.amis.pogamut.emohawk.agent.module.stream.IOutputStream;

public class ListAttributeReplica<Element> extends AbstractGenericObjectReplica implements IAssignableAttributeReplica<Iterable<Element>> {

	protected AbstractAttributeReplica<Iterable<Element>> abstractAttribute = new AbstractAttributeReplica<Iterable<Element>>() {
		@Override
		public void serialize(IOutputStream stream, Iterable<Element> value) {
			LinkedList<Element> list = new LinkedList<Element>(); 
			for ( Element element : value ) {
				list.add( element );
			}
			stream.writeInt( list.size() );
			for ( Element element : list ) {
				PrimitiveTools.writePrimitive( element, stream );
			}
		}
	};
	
	public ListAttributeReplica() {
		super(1);
	}
	
	@SuppressWarnings("unchecked")
	public SpecializedClass<Element> getElementType() {
		return (SpecializedClass<Element>) typeParameters[0];
	}
	
	@Override
	public void receive( IInputObjectStream stream) {
		abstractAttribute.receive( stream );
	}

	@Override
	public AttributeAccess getAccess() {
		return abstractAttribute.getAccess();
	}

	@Override
	public int getOwnerControllerId() {
		return abstractAttribute.getOwnerControllerId();
	}

	@Override
	public void serialize(IOutputStream stream, Iterable<Element> value) {
		abstractAttribute.serialize( stream, value );
	}

	@SuppressWarnings("unchecked")
	public SinglyLinkedListReplica<Element> getValue() {
		return (SinglyLinkedListReplica<Element>) abstractAttribute.getValue();
	}
}
