/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.emohawk.agent.module.replication.image.ds;

import cz.cuni.amis.pogamut.emohawk.agent.module.replication.image.object.IObjectReplication;
import cz.cuni.amis.pogamut.emohawk.agent.module.stream.IInputObjectStream;
import cz.cuni.amis.pogamut.emohawk.agent.module.stream.IOutputStream;

public class PrimitiveTools {
    public static Object readPrimitive(Class<?> primitiveClass, IInputObjectStream inputStream) {
        if (primitiveClass == Integer.class) {
            return new Integer(inputStream.readInt());
        }
        if (primitiveClass == Boolean.class) {
            return new Boolean(inputStream.readBool());
        }
        if (primitiveClass == String.class) {
            return inputStream.readString();
        }
        if (primitiveClass == Float.class) {
            return new Float(inputStream.readFloat());
        }
        if (IObjectReplication.class.isAssignableFrom(primitiveClass)) {
            return inputStream.readObjectRef();
        }
        throw new AssertionError((Object)("Unexpected primitive class " + primitiveClass));
    }

    public static void writePrimitive(Object primitive, IOutputStream outputStream) {
        if (primitive instanceof Integer) {
            outputStream.writeInt((Integer)primitive);
        } else if (primitive instanceof Boolean) {
            outputStream.writeBool((Boolean)primitive);
        } else if (primitive instanceof String) {
            outputStream.writeString((String)primitive);
        } else if (primitive instanceof Float) {
            outputStream.writeFloat(((Float)primitive).floatValue());
        } else {
            if (primitive instanceof IObjectReplication) {
                throw new AssertionError((Object)"Object references not supported.");
            }
            throw new AssertionError((Object)("Unexpected primitive class " + primitive.getClass()));
        }
    }
}

