/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.emohawk.agent.module.replication.image.attribute;

import cz.cuni.amis.pogamut.emohawk.agent.module.attribute.AttributeUpstream;
import cz.cuni.amis.pogamut.emohawk.agent.module.replication.image.attribute.AttributeAccess;
import cz.cuni.amis.pogamut.emohawk.agent.module.replication.image.attribute.IAssignableAttributeReplication;
import cz.cuni.amis.pogamut.emohawk.agent.module.replication.image.attribute.IAttributeReplication;
import cz.cuni.amis.pogamut.emohawk.agent.module.replication.image.ds.ListMapEntryReplication;
import cz.cuni.amis.pogamut.emohawk.agent.module.replication.image.ds.ListMapReplication;
import cz.cuni.amis.pogamut.emohawk.agent.module.replication.image.object.SpecializedClass;
import java.util.Iterator;

public class AttributeRawView<Attribute extends IAssignableAttributeReplication<IntermediateValue>, IntermediateValue> {
    protected SpecializedClass<Attribute> attributeClass;
    protected AttributeUpstream upstream;
    protected ListMapReplication<IAttributeReplication> attributes;

    public AttributeRawView(ListMapReplication<IAttributeReplication> attributes, AttributeUpstream upstream, SpecializedClass<Attribute> attributeClass) {
        this.attributes = attributes;
        this.upstream = upstream;
        this.attributeClass = attributeClass;
    }

    public ListMapReplication<IAttributeReplication> getAttributes() {
        return this.attributes;
    }

    public Attribute getAttributeRecord(String attributeName) {
        IAssignableAttributeReplication attribute = (IAssignableAttributeReplication)this.attributes.get(attributeName);
        assert (this.attributeClass.isInstance(attribute));
        return (Attribute)attribute;
    }

    public void send(String attributeName, IntermediateValue value) {
        Attribute attribute = this.getAttributeRecord(attributeName);
        assert (attribute.getAccess() == AttributeAccess.ATTRIBUTE_ACCESS_WRITE);
        assert (attribute.getOwnerControllerId() == -1 || attribute.getOwnerControllerId() == this.upstream.getControllerId());
        attribute.serialize(this.upstream.getOutputStream(), value);
        this.upstream.setAttribute(attribute.getReplicationId());
    }

    public boolean exists(String attributeName, AttributeAccess access) {
        if (this.attributes.containsKey(attributeName)) {
            IAttributeReplication attribute = this.attributes.get(attributeName);
            return this.attributeClass.isInstance(attribute) && attribute.getAccess() == access;
        }
        return false;
    }

    public Iterator<ListMapEntryReplication<Attribute>> iterator() {
        final Iterator<ListMapEntryReplication<IAttributeReplication>> iterator = this.attributes.iterator();
        return new Iterator<ListMapEntryReplication<Attribute>>(){
            ListMapEntryReplication<Attribute> next;

            @Override
            public boolean hasNext() {
                this.fetchNext();
                return this.next != null;
            }

            @Override
            public ListMapEntryReplication<Attribute> next() {
                this.fetchNext();
                assert (this.next != null);
                return this.next;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("Can't remove attribute.");
            }

            protected void fetchNext() {
                if (this.next != null) {
                    return;
                }
                while (iterator.hasNext()) {
                    ListMapEntryReplication candidate = (ListMapEntryReplication)iterator.next();
                    if (!AttributeRawView.this.attributeClass.isInstance(candidate.getValue())) continue;
                    this.next = new ListMapEntryReplication<IAssignableAttributeReplication>(candidate.getKey(), (IAssignableAttributeReplication)candidate.getValue());
                    return;
                }
            }
        };
    }
}

