/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.emohawk.agent.module.action;

import cz.cuni.amis.pogamut.base.communication.command.IAct;
import cz.cuni.amis.pogamut.base.communication.messages.CommandMessage;
import cz.cuni.amis.pogamut.base.communication.worldview.IWorldView;
import cz.cuni.amis.pogamut.base.communication.worldview.event.IWorldEventListener;
import cz.cuni.amis.pogamut.base.utils.logging.LogCategory;
import cz.cuni.amis.pogamut.emohawk.agent.module.replication.image.action.IActionReplication;
import cz.cuni.amis.pogamut.emohawk.agent.module.replication.image.action.IActionResultHandler;
import cz.cuni.amis.pogamut.emohawk.agent.module.replication.image.action.IPerformerReplication;
import cz.cuni.amis.pogamut.emohawk.agent.module.replication.image.action.MajorActionResult;
import cz.cuni.amis.pogamut.emohawk.agent.module.stream.IInputStream;
import cz.cuni.amis.pogamut.emohawk.agent.module.stream.IOutputStream;
import cz.cuni.amis.pogamut.emohawk.communication.action.ActionResult;
import cz.cuni.amis.pogamut.emohawk.communication.action.PerformAction;
import cz.cuni.amis.pogamut.emohawk.communication.stream.PayloadType;
import cz.cuni.amis.pogamut.ut2004.agent.module.sensor.Game;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class ActionUpstream {
    protected IAct act;
    protected IWorldView view;
    protected Game game;
    protected IOutputStream outputStream;
    protected LogCategory log;
    protected Map<Integer, HandlerRecord> resultHandlers;
    protected int nextUserRequestId;
    protected double timeoutPeriod;
    protected IWorldEventListener<ActionResult> onInteractionError = new IWorldEventListener<ActionResult>(){

        public void notify(ActionResult event) {
            ActionUpstream.this.cleanHandlers();
            HandlerRecord handlerRecord = ActionUpstream.this.resultHandlers.get(event.getUserRequestId());
            if (handlerRecord != null) {
                handlerRecord.handler.handle(event.getMajor(), event.getMinor(), event.getMessage());
                if (event.getMajor() == MajorActionResult.IR_SUCCESS || event.getMajor() == MajorActionResult.IR_FAILURE) {
                    ActionUpstream.this.resultHandlers.remove(event.getUserRequestId());
                } else {
                    handlerRecord.timeoutTime = ActionUpstream.this.game.getTime() + ActionUpstream.this.timeoutPeriod;
                }
            }
        }
    };

    public ActionUpstream(IAct act, IWorldView view, Game game, IOutputStream outputStream, LogCategory log) {
        this.act = act;
        this.view = view;
        this.game = game;
        this.outputStream = outputStream;
        this.log = log;
        this.resultHandlers = new HashMap<Integer, HandlerRecord>();
        this.nextUserRequestId = 1;
        this.timeoutPeriod = 30.0;
        view.addEventListener(ActionResult.class, this.onInteractionError);
    }

    void setTimeoutPeriod(float value) {
        this.timeoutPeriod = value;
    }

    public void requestAction(IPerformerReplication performer, IActionReplication action, IActionResultHandler resultHandler, IInputStream serializedCustomArguments) {
        this.cleanHandlers();
        int requestId = this.generateRequestId();
        if (resultHandler != null) {
            this.resultHandlers.put(requestId, new HandlerRecord(this.game.getTime() + this.timeoutPeriod, resultHandler));
        }
        if (serializedCustomArguments != null) {
            block6: while (serializedCustomArguments.tellNext() != PayloadType.PAYLOAD_TYPE_EOF) {
                switch (serializedCustomArguments.tellNext()) {
                    case PAYLOAD_TYPE_BOOL: {
                        this.outputStream.writeBool(serializedCustomArguments.readBool());
                        continue block6;
                    }
                    case PAYLOAD_TYPE_INT: {
                        this.outputStream.writeInt(serializedCustomArguments.readInt());
                        continue block6;
                    }
                    case PAYLOAD_TYPE_FLOAT: {
                        this.outputStream.writeFloat(serializedCustomArguments.readFloat());
                        continue block6;
                    }
                    case PAYLOAD_TYPE_STRING: {
                        this.outputStream.writeString(serializedCustomArguments.readString());
                        continue block6;
                    }
                }
                throw new AssertionError((Object)"Unexpected payload type.");
            }
        }
        this.act.act((CommandMessage)new PerformAction(performer.getReplicationId(), action.getReplicationId(), requestId));
    }

    protected void cleanHandlers() {
        Iterator<HandlerRecord> iterator = this.resultHandlers.values().iterator();
        while (iterator.hasNext()) {
            HandlerRecord record = iterator.next();
            if (!(record.timeoutTime < this.game.getTime())) continue;
            if (this.log != null) {
                this.log.warning("Action result handler timed out.");
            }
            iterator.remove();
        }
    }

    protected int generateRequestId() {
        return this.nextUserRequestId++;
    }

    static class HandlerRecord {
        public double timeoutTime;
        public IActionResultHandler handler;

        public HandlerRecord(double timeoutTime, IActionResultHandler handler) {
            this.timeoutTime = timeoutTime;
            this.handler = handler;
        }
    }
}

