/*
 * Decompiled with CFR 0.152.
 */
package javabot;

import cz.cuni.amis.pogamut.base.agent.state.impl.AgentState;
import cz.cuni.amis.pogamut.base.agent.state.impl.AgentStateStarted;
import cz.cuni.amis.pogamut.base.communication.translator.event.IWorldChangeEvent;
import cz.cuni.amis.pogamut.defcon.agent.DefConAgent;
import cz.cuni.amis.pogamut.defcon.agent.module.sensor.GameInfo;
import cz.cuni.amis.pogamut.defcon.agentmanager.DefConAgentManager;
import cz.cuni.amis.pogamut.defcon.agentmanager.exception.CantInstantiateAgentException;
import cz.cuni.amis.pogamut.defcon.agentmanager.exception.ModuleForAgentClassNotFoundException;
import cz.cuni.amis.pogamut.defcon.base3d.worldview.object.DefConLocation;
import cz.cuni.amis.pogamut.defcon.communication.messages.commands.DefConCommand;
import cz.cuni.amis.pogamut.defcon.communication.messages.infos.City;
import cz.cuni.amis.pogamut.defcon.communication.messages.infos.DefConEvent;
import cz.cuni.amis.pogamut.defcon.communication.messages.infos.DefConObject;
import cz.cuni.amis.pogamut.defcon.communication.messages.infos.DefConUnitObject;
import cz.cuni.amis.pogamut.defcon.communication.messages.infos.Fleet;
import cz.cuni.amis.pogamut.defcon.consts.Event;
import cz.cuni.amis.pogamut.defcon.consts.UnitType;
import cz.cuni.amis.pogamut.defcon.utils.SyncMethodExecContainer;
import cz.cuni.amis.utils.ExceptionToString;
import cz.cuni.amis.utils.exception.PogamutInterruptedException;
import cz.cuni.amis.utils.flag.Flag;
import cz.cuni.amis.utils.flag.IFlag;
import cz.cuni.amis.utils.flag.WaitForFlagChange;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import javabot.ActExecutor;
import javabot.JBot;
import javabot.events.DefConBasicUpdate;
import javabot.events.IDefConBasicEvent;

public class PogamutJBotSupport {
    private static final String NEW_LINE = System.getProperty("line.separator");
    public static final String PROPERTY_CLASS = "module_class";
    public static final String PROPERTY_START_TIMEOUT_SECS = "start_timeout";
    private static final int DEFAULT_START_TIMEOUT_SECS = 10;
    private static final long MAX_UPDATE_TIME = 75L;
    private static DefConAgent bot = null;
    private static final ConcurrentLinkedQueue<SyncMethodExecContainer> queries = new ConcurrentLinkedQueue();
    private static final LinkedBlockingQueue<IDefConBasicEvent> events = new LinkedBlockingQueue();
    private static final LinkedBlockingQueue<IWorldChangeEvent> unitUpdates = new LinkedBlockingQueue();
    private static final int COMMANDS_PER_TICK = 20;
    public static Flag<Boolean> botIsRunning = new Flag((Object)false);
    private static ConcurrentLinkedQueue<DefConCommand> commands = new ConcurrentLinkedQueue();
    private static ActExecutor actExecutor = new ActExecutor();
    public static GameInfo gameInfo = null;

    private static String mapToString(Map<?, ?> map) {
        StringBuffer sb = new StringBuffer();
        for (Map.Entry<?, ?> entry : map.entrySet()) {
            sb.append(entry.getKey() + " = " + entry.getValue());
            sb.append(NEW_LINE);
        }
        return sb.toString();
    }

    private static boolean start(Map<String, String> options) {
        PogamutJBotSupport.logInit(Level.INFO, "Instantiating bot with options: " + NEW_LINE + PogamutJBotSupport.mapToString(options));
        String clsStr = options.get(PROPERTY_CLASS);
        Class<?> cls = null;
        if (clsStr != null) {
            try {
                cls = Class.forName(clsStr);
            }
            catch (Exception e) {
                PogamutJBotSupport.logInit(Level.SEVERE, "Bot module class '" + clsStr + "' could not be found, did you put your jar into 'java' directory?");
                PogamutJBotSupport.logInit(Level.SEVERE, "BOT CAN NOT BE STARTED!");
                PogamutJBotSupport.logInit(Level.SEVERE, "RESTART DEFCON! " + e.toString() + " " + System.getProperty("java.class.path"));
                return false;
            }
            PogamutJBotSupport.logInit(Level.INFO, "Bot module class '" + clsStr + "'.");
        } else {
            PogamutJBotSupport.logInit(Level.INFO, "Bot module class ('module_class' options) not specified.");
        }
        PogamutJBotSupport.logInit(Level.INFO, "Instantiating bot.");
        try {
            bot = DefConAgentManager.getInstance().getAgentInstance(cls);
        }
        catch (CantInstantiateAgentException e) {
            PogamutJBotSupport.logInit(Level.SEVERE, ExceptionToString.process((Throwable)((Object)e)));
            PogamutJBotSupport.logInit(Level.SEVERE, "BOT CAN NOT BE STARTED!");
            PogamutJBotSupport.logInit(Level.SEVERE, "RESTART DEFCON!");
            return false;
        }
        catch (ModuleForAgentClassNotFoundException e) {
            PogamutJBotSupport.logInit(Level.SEVERE, ExceptionToString.process((Throwable)((Object)e)));
            PogamutJBotSupport.logInit(Level.SEVERE, "BOT CAN NOT BE STARTED!");
            PogamutJBotSupport.logInit(Level.SEVERE, "RESTART DEFCON!");
            return false;
        }
        PogamutJBotSupport.logInit(Level.INFO, "Bot was instantiated.");
        String startTimeoutStr = options.get(PROPERTY_START_TIMEOUT_SECS);
        int startTimeoutSecs = 10;
        if (startTimeoutStr != null) {
            try {
                startTimeoutSecs = Integer.parseInt(startTimeoutStr);
            }
            catch (Exception e) {
                PogamutJBotSupport.logInit(Level.WARNING, "Option 'start_timeout' does not contain integer number.");
            }
        }
        PogamutJBotSupport.logInit(Level.INFO, "Starting bot (" + startTimeoutSecs + " secs timeout).");
        bot.setOptions(options);
        try {
            bot.start();
            try {
                new WaitForFlagChange((IFlag)bot.getState(), (WaitForFlagChange.IAccept)new WaitForFlagChange.IAccept<AgentState>(){

                    public boolean accept(AgentState flagValue) {
                        return flagValue.isState(new Class[]{AgentStateStarted.class});
                    }
                }).await((long)startTimeoutSecs, TimeUnit.SECONDS);
            }
            catch (PogamutInterruptedException e) {
                PogamutJBotSupport.logInit(Level.SEVERE, "Bot fails to start in " + startTimeoutSecs + " secs, killing bot.");
                bot.kill();
                PogamutJBotSupport.logInit(Level.SEVERE, "BOT CAN NOT BE STARTED!");
                PogamutJBotSupport.logInit(Level.SEVERE, "RESTART DEFCON!");
                return false;
            }
        }
        catch (Exception e) {
            PogamutJBotSupport.logInit(Level.SEVERE, ExceptionToString.process((String)"Bot fails to start.", (Throwable)e));
            bot = null;
            PogamutJBotSupport.logInit(Level.SEVERE, "BOT CAN NOT BE STARTED!");
            PogamutJBotSupport.logInit(Level.SEVERE, "RESTART DEFCON!");
            return false;
        }
        PogamutJBotSupport.logInit(Level.INFO, "Bot running!");
        botIsRunning.setFlag((Object)true);
        return true;
    }

    public static DefConAgent<?> getBot() {
        return bot;
    }

    private static String[] split(String msg, int len) {
        if (msg.length() < len) {
            return new String[]{msg};
        }
        String[] result = new String[msg.length() / len + 1];
        for (int i = 0; i < msg.length() / len + 1; ++i) {
            result[i] = (i + 1) * len < msg.length() ? msg.substring(i * len, (i + 1) * len) : msg.substring(i * len);
        }
        return result;
    }

    public static void logInitException(Throwable e) {
        StringWriter writer = new StringWriter();
        e.printStackTrace(new PrintWriter(writer));
        PogamutJBotSupport.writeToConsole(writer.toString());
    }

    public static void logGameException(Throwable e) {
        StringWriter writer = new StringWriter();
        e.printStackTrace(new PrintWriter(writer));
        PogamutJBotSupport.writeToConsole(writer.toString());
    }

    public static void logInit(Level level, String msg) {
        if (((Boolean)botIsRunning.getFlag()).booleanValue()) {
            String[] msgs;
            for (String m : msgs = PogamutJBotSupport.split("[" + level + "] " + msg, 50)) {
                PogamutJBotSupport.writeToConsole(m);
            }
        } else {
            System.out.println("[" + level + "] " + msg);
        }
    }

    public static void logGame(Level level, String msg) {
        if (((Boolean)botIsRunning.getFlag()).booleanValue()) {
            JBot.DebugLog("[" + level + "] " + msg);
        } else {
            System.out.println("[" + level + "] " + msg);
        }
    }

    public static boolean initialise(String[][] commandLineOptions) {
        PogamutJBotSupport.writeToConsole("Executing PogamutJBotSupport initialise");
        PogamutJBotSupport.logGame(Level.INFO, "Executing PogamutJBotSupport initialise");
        StringBuffer sb = new StringBuffer();
        sb.append("Command line options:");
        HashMap<String, String> optionMap = new HashMap<String, String>();
        for (String[] option : commandLineOptions) {
            sb.append(NEW_LINE);
            if (option.length <= 0) continue;
            PogamutJBotSupport.logInit(Level.INFO, option[0] + (option.length > 1 && option[1].length() > 0 ? " = " + option[1] : ""));
            optionMap.put(option[0], option.length > 1 ? option[1] : null);
        }
        PogamutJBotSupport.logGame(Level.INFO, "Calling start");
        boolean result = PogamutJBotSupport.start(optionMap);
        JBot.WriteToConsole("Finished start");
        Thread.currentThread().setPriority(6);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addEvent(JBot.EventData data) {
        LinkedBlockingQueue<IDefConBasicEvent> linkedBlockingQueue = events;
        synchronized (linkedBlockingQueue) {
            if (data.m_eventType != 5) {
                DefConEvent event = Event.getInstanceOfUnitTypeFromEventType(data, bot.getWorldView().getCurrentTime());
                events.add(event);
            } else {
                int fleetId;
                int[] fleetMembers;
                JBot.UnitData unitdata = new JBot.UnitData();
                unitdata.m_objectId = data.m_targetObjectId;
                unitdata.m_teamId = JBot.GetTeamId(data.m_targetObjectId);
                unitdata.m_type = JBot.GetType(data.m_targetObjectId);
                unitdata.m_currentState = -1;
                unitdata.m_visible = true;
                unitdata.m_longitude = data.m_longitude;
                unitdata.m_latitude = data.m_latitude;
                if (UnitType.naval.contains((Object)UnitType.getEnum(unitdata.m_type)) && (fleetMembers = JBot.GetFleetMembers(fleetId = JBot.GetFleetId(data.m_targetObjectId))).length == 1) {
                    Fleet fleet_object = new Fleet(fleetId, unitdata.m_teamId, new DefConLocation(data.m_longitude, data.m_latitude), false, fleetMembers, (double)bot.getWorldView().getCurrentTime());
                    unitUpdates.add((IWorldChangeEvent)fleet_object.createDestroyedEvent());
                }
                DefConUnitObject update_object = (DefConUnitObject)UnitType.getInstanceOfUnitTypeFromUnitData(unitdata, bot.getWorldView().getCurrentTime());
                unitUpdates.add((IWorldChangeEvent)update_object.createDestroyedEvent());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean update() {
        long current_time = System.currentTimeMillis();
        if (JBot.IsVictoryTimerActive() && JBot.GetVictoryTimer() == 0.0f) {
            PogamutJBotSupport.writeToConsole("Match result");
            for (int teamId : JBot.GetTeamIds()) {
                PogamutJBotSupport.writeToConsole("TeamId: " + teamId);
                PogamutJBotSupport.writeToConsole("EnemyKills: " + JBot.GetEnemyKills(teamId));
                PogamutJBotSupport.writeToConsole("CollateralDamage: " + JBot.GetCollateralDamage(teamId));
                PogamutJBotSupport.writeToConsole("Casualties: " + JBot.GetFriendlyDeaths(teamId));
                PogamutJBotSupport.writeToConsole("RemainingPopulation: " + JBot.GetRemainingPopulation(teamId));
            }
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            System.exit(0);
        }
        PogamutJBotSupport.performCommands();
        PogamutJBotSupport.prepareUnitsUpdate();
        LinkedBlockingQueue<IDefConBasicEvent> linkedBlockingQueue = events;
        synchronized (linkedBlockingQueue) {
            events.add(new DefConBasicUpdate((long)JBot.GetGameTime()));
        }
        while (System.currentTimeMillis() - current_time < 75L) {
            PogamutJBotSupport.checkQueries();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void prepareUnitsUpdate() {
        LinkedBlockingQueue<IWorldChangeEvent> linkedBlockingQueue = unitUpdates;
        synchronized (linkedBlockingQueue) {
            List<JBot.UnitData> unit_data = JBot.GetAllUnitData();
            float time = JBot.GetGameTime();
            for (JBot.UnitData unit : unit_data) {
                DefConObject object = UnitType.getInstanceOfUnitTypeFromUnitData(unit, time);
                unitUpdates.add((IWorldChangeEvent)object.createUpdateEvent());
            }
            List<JBot.FleetData> fleet_data = JBot.GetAllFleetData();
            for (JBot.FleetData fleet : fleet_data) {
                Fleet object = new Fleet(fleet.m_fleetId, fleet.m_teamId, new DefConLocation(fleet.m_longitude, fleet.m_latitude), fleet.m_visible, fleet.m_fleetMembers, (double)time);
                if (object.getFleetMembers().length <= 0) continue;
                unitUpdates.add((IWorldChangeEvent)object.createUpdateEvent());
            }
            for (int cityId : JBot.GetCityIds()) {
                DefConLocation cityLocation = new DefConLocation(JBot.GetLongitude(cityId), JBot.GetLatitude(cityId));
                int ownerId = JBot.GetTeamId(cityId);
                City city = new City(cityId, ownerId, cityLocation, true, JBot.GetCityPopulation(cityId), (double)JBot.GetGameTime());
                unitUpdates.add((IWorldChangeEvent)city.createUpdateEvent());
            }
        }
    }

    public static List<IWorldChangeEvent> getUnitsUpdate() {
        ArrayList<IWorldChangeEvent> update = new ArrayList<IWorldChangeEvent>();
        unitUpdates.drainTo(update);
        return update;
    }

    private static void checkQueries() {
        SyncMethodExecContainer container = queries.poll();
        if (container != null) {
            container.execute();
        }
    }

    public static synchronized void addQuery(SyncMethodExecContainer container) {
        queries.add(container);
    }

    private static void performCommands() {
        int counter = 20;
        while (--counter > 0 && !commands.isEmpty()) {
            actExecutor.sendCommand(commands.poll());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addCommand(DefConCommand command) {
        ConcurrentLinkedQueue<DefConCommand> concurrentLinkedQueue = commands;
        synchronized (concurrentLinkedQueue) {
            commands.add(command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<IDefConBasicEvent> getEvents() {
        ArrayList<IDefConBasicEvent> result = new ArrayList<IDefConBasicEvent>();
        LinkedBlockingQueue<IDefConBasicEvent> linkedBlockingQueue = events;
        synchronized (linkedBlockingQueue) {
            events.drainTo(result);
        }
        return result;
    }

    public static void writeToConsole(String logLine) {
        if (logLine != null) {
            JBot.WriteToConsole(logLine);
        } else {
            JBot.WriteToConsole("NULL LOGLINE");
            for (StackTraceElement element : Thread.currentThread().getStackTrace()) {
                JBot.WriteToConsole(element.toString());
            }
        }
    }

    public static ActExecutor getDefConActExecutor() {
        return actExecutor;
    }

    public static void setName(String name) {
        JBot.SendChatMessage(String.format("/name [Bot]%s", name), 0);
    }
}

