/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.defcon.communication.worldview;

import cz.cuni.amis.pogamut.base3d.worldview.object.Location;
import cz.cuni.amis.pogamut.defcon.agent.module.sensor.GameInfo;
import cz.cuni.amis.pogamut.defcon.communication.worldview.AbstractMapSource;
import cz.cuni.amis.pogamut.defcon.communication.worldview.modules.grid.flags.BasicFlag;
import cz.cuni.amis.pogamut.defcon.consts.UnitType;
import cz.cuni.amis.pogamut.defcon.utils.Pair;
import java.io.BufferedWriter;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.util.BitSet;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.logging.Logger;

public class NativeMapSource
extends AbstractMapSource {
    private final SortedMap<Integer, Pair<BitSet, BitSet>> unifiedTerritories = new TreeMap<Integer, Pair<BitSet, BitSet>>();
    private final BitSet sailable;
    private final Pair<BitSet, BitSet> ownTerritories = new Pair();
    private final SortedMap<Integer, Pair<BitSet, BitSet>> enemyTerritories = new TreeMap<Integer, Pair<BitSet, BitSet>>();
    private final Logger log;
    private final double X_SPAN = 180.0;
    private final double Y_SPAN = 100.0;
    private GameInfo gameInfo;

    public NativeMapSource(GameInfo gameInfo) {
        this(gameInfo, null);
    }

    public NativeMapSource(GameInfo gameInfo, Logger log) {
        int[] teamIds;
        this.gameInfo = gameInfo;
        this.log = log;
        this.sailable = this.cache(BasicFlag.SEA);
        this.testOutput("sailable", this.sailable);
        for (int teamId : teamIds = gameInfo.getTeamIds()) {
            if (teamId == gameInfo.getOwnTeamId()) {
                this.ownTerritories.first = this.cache(BasicFlag.OWN_PLACEABLE_SEA);
                this.ownTerritories.second = this.cache(BasicFlag.OWN_PLACEABLE_LAND);
                this.testOutput("own_sea", (BitSet)this.ownTerritories.first);
                this.testOutput("own_land", (BitSet)this.ownTerritories.second);
                this.unifiedTerritories.put(teamId, this.ownTerritories);
                continue;
            }
            Pair pair = new Pair();
            pair.first = this.cacheEnemy(BasicFlag.ENEMY_PLACEABLE_SEA, teamId);
            pair.second = this.cacheEnemy(BasicFlag.ENEMY_PLACEABLE_LAND, teamId);
            this.unifiedTerritories.put(teamId, pair);
            this.enemyTerritories.put(teamId, pair);
            this.testOutput("enemy_sea", (BitSet)pair.first);
            this.testOutput("enemy_land", (BitSet)pair.second);
        }
    }

    private void testOutput(String filename, BitSet flags) {
        try {
            BufferedWriter ostream = new BufferedWriter(new FileWriter(filename + ".def"));
            for (double i = -180.0; i < 180.0; i += 1.0) {
                for (double j = -100.0; j < 100.0; j += 1.0) {
                    int index = this.convert2dIndicesTo1d(i, j);
                    ostream.write(flags.get(index) ? "X" : " ");
                }
                ostream.write("\n");
            }
            ostream.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private BitSet cache(BasicFlag flag) {
        BitSet bit_set = new BitSet(72000);
        for (double i = -180.0; i < 180.0; i += 1.0) {
            for (double j = -100.0; j < 100.0; j += 1.0) {
                int index = this.convert2dIndicesTo1d(i, j);
                boolean isPresent = this.hasFlagWorker(i, j, flag);
                bit_set.set(index, isPresent);
            }
        }
        return bit_set;
    }

    private BitSet cacheEnemy(BasicFlag flag, int teamId) {
        boolean sea;
        switch (flag) {
            case ENEMY_PLACEABLE_LAND: {
                sea = false;
                break;
            }
            case ENEMY_PLACEABLE_SEA: {
                sea = true;
                break;
            }
            default: {
                return null;
            }
        }
        BitSet bit_set = new BitSet(72000);
        for (double i = -180.0; i < 180.0; i += 1.0) {
            for (double j = -100.0; j < 100.0; j += 1.0) {
                int index = this.convert2dIndicesTo1d(i, j);
                boolean isPresent = this.hasEnemyTerritoryFlagWorker(i, j, teamId, sea);
                bit_set.set(index, isPresent);
            }
        }
        return bit_set;
    }

    private final int convert2dIndicesTo1d(double x, double y) {
        return (int)((x + 180.0) * 180.0) + (int)(y + 100.0);
    }

    private boolean hasFlagWorker(double x, double y, BasicFlag flag) {
        if (x < -180.0 || x > 180.0 || y < -100.0 || y > 100.0) {
            return false;
        }
        switch (flag) {
            case SEA: {
                return this.gameInfo.isValidTerritory(-1, x, y, true);
            }
            case LAND: {
                return this.gameInfo.isValidTerritory(-1, x, y, false);
            }
            case OWN_TERRITORY: {
                int id = this.gameInfo.getOwnTeamId();
                return this.gameInfo.isValidTerritory(id, x, y, false) || this.gameInfo.isValidTerritory(id, x, y, true);
            }
            case ENEMY_TERRITORY: {
                int id;
                Boolean ok = false;
                int[] arr$ = this.gameInfo.getEnemyTeamIds();
                int len$ = arr$.length;
                for (int i$ = 0; i$ < len$ && !(ok = Boolean.valueOf(this.hasEnemyTerritoryFlagWorker(x, y, id = arr$[i$]))).booleanValue(); ++i$) {
                }
                return ok;
            }
            case OWN_PLACEABLE_LAND: {
                return this.gameInfo.isValidPlacementLocation(x, y, UnitType.RADAR);
            }
            case OWN_PLACEABLE_SEA: {
                return this.gameInfo.isValidPlacementLocation(x, y, UnitType.BATTLE_SHIP);
            }
            case ENEMY_PLACEABLE_LAND: {
                for (int id : this.gameInfo.getEnemyTeamIds()) {
                    if (!this.hasEnemyTerritoryFlagWorker(x, y, id, false)) continue;
                    return true;
                }
                return false;
            }
            case ENEMY_PLACEABLE_SEA: {
                for (int id : this.gameInfo.getEnemyTeamIds()) {
                    if (!this.hasEnemyTerritoryFlagWorker(x, y, id, true)) continue;
                    return true;
                }
                return false;
            }
        }
        return false;
    }

    private boolean hasEnemyTerritoryFlagWorker(double x, double y, int enemyId) {
        return this.gameInfo.isValidTerritory(enemyId, x, y, false) || this.gameInfo.isValidTerritory(enemyId, x, y, true);
    }

    private boolean hasEnemyTerritoryFlagWorker(double x, double y, int enemyId, boolean seaArea) {
        return this.gameInfo.isValidTerritory(enemyId, x, y, seaArea);
    }

    @Override
    public boolean hasFlag(Location location, BasicFlag flag) {
        return this.hasFlag(location.getX(), location.getY(), flag);
    }

    @Override
    public boolean hasFlag(double x, double y, BasicFlag flag) {
        if (x < -180.0 || x > 180.0 || y < -100.0 || y > 100.0) {
            return false;
        }
        int index = this.convert2dIndicesTo1d(x, y);
        switch (flag) {
            case SEA: {
                return this.sailable.get(index);
            }
            case LAND: {
                return !this.sailable.get(index);
            }
            case OWN_TERRITORY: {
                return ((BitSet)this.ownTerritories.first).get(index) || ((BitSet)this.ownTerritories.second).get(index);
            }
            case OWN_PLACEABLE_SEA: {
                return ((BitSet)this.ownTerritories.first).get(index);
            }
            case OWN_PLACEABLE_LAND: {
                return ((BitSet)this.ownTerritories.second).get(index);
            }
            case ENEMY_TERRITORY: {
                for (Pair<BitSet, BitSet> enemyArea : this.enemyTerritories.values()) {
                    if (!((BitSet)enemyArea.first).get(index) && !((BitSet)enemyArea.second).get(index)) continue;
                    return true;
                }
                return false;
            }
            case ENEMY_PLACEABLE_SEA: {
                for (Pair<BitSet, BitSet> enemyArea : this.enemyTerritories.values()) {
                    if (!((BitSet)enemyArea.first).get(index)) continue;
                    return true;
                }
                return false;
            }
            case ENEMY_PLACEABLE_LAND: {
                for (Pair<BitSet, BitSet> enemyArea : this.enemyTerritories.values()) {
                    if (!((BitSet)enemyArea.second).get(index)) continue;
                    return true;
                }
                return false;
            }
        }
        return false;
    }

    @Override
    public boolean hasEnemyTerritoryFlag(Location location, int enemyId) {
        return this.hasEnemyTerritoryFlag(location.getX(), location.getY(), enemyId);
    }

    @Override
    public boolean hasEnemyTerritoryFlag(double x, double y, int enemyId) {
        int index = this.convert2dIndicesTo1d(x, y);
        return ((BitSet)((Pair)this.enemyTerritories.get((Object)Integer.valueOf((int)enemyId))).first).get(index) || ((BitSet)((Pair)this.enemyTerritories.get((Object)Integer.valueOf((int)enemyId))).second).get(index);
    }

    @Override
    public boolean hasEnemyTerritoryFlag(Location location, int enemyId, boolean seaArea) {
        return this.hasEnemyTerritoryFlag(location.getX(), location.getY(), enemyId, seaArea);
    }

    @Override
    public boolean hasEnemyTerritoryFlag(double x, double y, int enemyId, boolean seaArea) {
        int index = this.convert2dIndicesTo1d(x, y);
        if (seaArea) {
            return ((BitSet)((Pair)this.enemyTerritories.get((Object)Integer.valueOf((int)enemyId))).first).get(index);
        }
        return ((BitSet)((Pair)this.enemyTerritories.get((Object)Integer.valueOf((int)enemyId))).second).get(index);
    }
}

