package cz.cuni.amis.pogamut.defcon.communication.worldview.modules.grid.flags;

import cz.cuni.amis.pogamut.defcon.base3d.worldview.object.DefConLocation;
import cz.cuni.amis.pogamut.base3d.worldview.object.Location;

/**
 * Interface for the map sources. Provides access to map features and tracing
 * methods.
 * 
 * @author Radek 'Black_Hand' Pibil
 * 
 */
public interface IFlagChecker {
	
	/**
	 * Returns true if the flag is present on the given location. Uses cached
	 * values.
	 * 
	 * @param location
	 * @param flag
	 * @return
	 */
	public boolean hasFlag(Location location, BasicFlag flag);

	/**
	 * Returns true if the flag is present on the given location. Uses cached
	 * values.
	 * 
	 * @param x
	 * @param y
	 * @param flag
	 * @return
	 */
	public boolean hasFlag(double x, double y, BasicFlag flag);

	/**
	 * Returns true if the given location is a valid territory for the given
	 * teamId.
	 * 
	 * @param location
	 * @param enemyId
	 * @return
	 */
	public boolean hasEnemyTerritoryFlag(Location location, int enemyId);

	/**
	 * Returns true if the given location is a valid territory for the given
	 * teamId.
	 * 
	 * @param x
	 * @param y
	 * @param enemyId
	 * @return
	 */
	public boolean hasEnemyTerritoryFlag(double x, double y, int enemyId);

	/**
	 * Returns true if the given location is a valid territory for the given
	 * teamId.
	 * 
	 * @param location
	 * @param enemyId
	 * @param seaArea
	 *            if true then checks, whether [x, y] is a sea territory
	 * @return
	 */
	public boolean hasEnemyTerritoryFlag(Location location, int enemyId,
			boolean seaArea);

	public boolean hasEnemyTerritoryFlag(double x, double y, int enemyId,
			boolean seaArea);

	/**
	 * Returns the closest position to end from start, which has the proper
	 * flag.
	 * 
	 * @param start
	 * @param end
	 * @param flag
	 * @return
	 */
	public DefConLocation traceFromTo(DefConLocation start, DefConLocation end,
			BasicFlag flag);

	/**
	 * Returns the a position on line to end from start, which has the proper
	 * flag and is as far as possible, while closer than distance from the
	 * closest position.
	 * 
	 * @param start
	 * @param end
	 * @param flag
	 * @param distance
	 * @return
	 */
	public DefConLocation traceFromTo(DefConLocation start, DefConLocation end,
			BasicFlag flag,
			double distance);
}
