package cz.cuni.amis.pogamut.defcon.agent;

import java.util.Map;

import com.google.inject.Inject;

import cz.cuni.amis.pogamut.base.agent.IAgentId;
import cz.cuni.amis.pogamut.base.agent.impl.AbstractEmbodiedAgent;
import cz.cuni.amis.pogamut.base.communication.command.impl.IJNIAct;
import cz.cuni.amis.pogamut.base.communication.worldview.event.IWorldEventListener;
import cz.cuni.amis.pogamut.base.component.bus.IComponentBus;
import cz.cuni.amis.pogamut.base.component.bus.event.BusAwareCountDownLatch;
import cz.cuni.amis.pogamut.base.utils.logging.IAgentLogger;
import cz.cuni.amis.pogamut.defcon.communication.command.impl.DefConAct;
import cz.cuni.amis.pogamut.defcon.communication.messages.commands.DefConCommand;
import cz.cuni.amis.pogamut.defcon.communication.messages.infos.GameRunningChanged;
import cz.cuni.amis.pogamut.defcon.communication.worldview.DefConWorldView;
import cz.cuni.amis.utils.NullCheck;

/**
 * Basic defcon agent implementation.
 * @author Radek 'Black_Hand' Pibil
 *
 * @param <CONTROLLER>
 */
public class DefConAgent<CONTROLLER extends IDefConAgentLogicController<DefConAgent<?>, ?>>
	extends AbstractEmbodiedAgent<DefConWorldView, IJNIAct>
	implements IDefConAgent {
	
	private CONTROLLER controller;

	private Map<String, String> arguments;

	/**
	 * Latch that is raised when {@link InitedMessage} comes.
	 */
	private BusAwareCountDownLatch initedLatch;
	
	private boolean gameStarted = false;
	
	private boolean botStoppedCalled;
	
	protected DefConWorldView worldview;

	private IWorldEventListener<GameRunningChanged> startListener = new IWorldEventListener<GameRunningChanged>() {

		@Override
		public void notify(GameRunningChanged event) {
			if (!event.getRunning())
				gameStarted();
		}
		
	};
	
	/**
	 * Inits a DefConAgent instance
	 * 
	 * @param agentId
	 * @param eventBus
	 * @param logger
	 * @param worldView
	 * @param act
	 * @param logic
	 */
	@Inject
	@SuppressWarnings("unchecked")
	public DefConAgent(IAgentId agentId, IComponentBus eventBus, IAgentLogger logger,
			DefConWorldView worldView, DefConAct act,
			IDefConAgentLogicController logic) {
		super(agentId, eventBus, logger, worldView, act);
		
		controller = (CONTROLLER) logic;
        NullCheck.check(this.controller, "init");
        logger.addToAllCategories(new DefConLogPublisher());
        log.finer("Initializing bot controller...");
        this.controller.initializeController(this);
        log.fine("Controller initialized.");
        worldView.addEventListener(GameRunningChanged.class, startListener);
		this.worldview = worldView;
	}
	
	/**
	 * Returns a set of arguments passed to defcon.
	 */
	@Override
	public Map<String, String> getArguments() {
		return arguments;
	}

	/**
	 * Used by PogamutJBotSupport to assign arguments.
	 */
	@Override
	public void setOptions(Map<String, String> arguments) {
		this.arguments = arguments;
	}

	@Override
	public DefConWorldView getWorldView() {
		return (DefConWorldView) super.getWorldView();
	}
	
    ////////  
    //
    // BOT CONTROL METHODS
    //
    ////////
    
    @Override
	protected void startAgent() {
    	botStoppedCalled = false;
    	super.startAgent();
    }
    
    @Override
    protected void stopAgent() {
    	try {
	    	if (botStoppedCalled) {
	    		controller.botStopped();
	    		botStoppedCalled = true;
	    	}
    	} finally {
    		super.stopAgent();
    	}
    }
    
    @Override
    protected void killAgent() {}
    	
	protected void gameStarted() {
		gameStarted = true;
	}    

    protected boolean gameHasStarted() {
    	return gameStarted;
    }
    
    @Override
    public void act(DefConCommand command) {
    	getAct().act(command);
    }
}
