/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.defcon.utils.quadtree;

import cz.cuni.amis.pogamut.defcon.utils.quadtree.QuadTree;
import cz.cuni.amis.pogamut.defcon.utils.quadtree.QuadTreeNode;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.NoSuchElementException;

public class QuadTreeBFSIterator
implements Iterator<QuadTreeNode> {
    private QuadTree tree;
    private QuadTreeNode node = null;
    private QuadTreeNode root = null;
    private boolean finished = false;
    private final LinkedList<QuadTreeNode> branching = new LinkedList();

    public QuadTreeBFSIterator(QuadTree tree) {
        if (tree == null) {
            throw new IllegalArgumentException("Tree cannot be null");
        }
        this.tree = tree;
        this.root = tree.getRoot();
        this.branching.addLast(this.root);
    }

    @Override
    public boolean hasNext() {
        return !this.branching.isEmpty();
    }

    @Override
    public QuadTreeNode next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        QuadTreeNode node = this.branching.pop();
        if (node.getNodes() != null) {
            for (QuadTreeNode child : node.getNodes()) {
                this.branching.addLast(child);
            }
        }
        return node;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("QuadTreeIterator does not support remove() method.");
    }
}

