package cz.cuni.amis.pogamut.defcon.utils.quadtree;

import java.util.logging.Logger;

import cz.cuni.amis.pogamut.defcon.communication.worldview.DefConWorldView;

/**
 * Relabels quadtree specifically for a simple building placement points lookup.
 * 
 * @author Radek 'Black_Hand' Pibil
 * 
 */
public class BuildingPlacementQuadTreeLabellingMethod implements
		IQuadTreeLabelingMethod {

	private DefConWorldView worldview;
	private Logger log;

	public BuildingPlacementQuadTreeLabellingMethod(DefConWorldView worldview,
			Logger log) {
		this.worldview = worldview;
		this.log = log;
	}

	/**
	 * Relabels the given node and all nodes underneath it for the purposes of
	 * building placing.
	 */
	@Override
	public boolean label(QuadTreeNode node) {

		if (node.isLabeled()) {
			if (node.getNodes() != null &&
					(node.getFirst().isLabeled() ||
							node.getSecond().isLabeled() ||
							node.getThird().isLabeled() ||
					node.getFourth().isLabeled())) {
				return true;
			}

			node.setLabel(false);

			return false;
		}

		boolean b = node.getNodes() == null && worldview.getGameInfo()
				.isValidBuildingPlacementLocation(
						node.getCenter().getX(),
						node.getCenter().getY());

		return b;

	}
}
