package cz.cuni.amis.pogamut.defcon.agent;

import java.util.Map;

import cz.cuni.amis.pogamut.base.agent.IEmbodiedAgent;
import cz.cuni.amis.pogamut.defcon.communication.messages.commands.DefConCommand;

/**
 * Sets some basic methods for DefConAgent.
 * @author Radek 'Black_Hand' Pibil
 */
public interface IDefConAgent 
		extends IEmbodiedAgent {
	
	/**
	 * Returns the list of command line arguments passed to defcon.
	 * @return
	 */
	public Map<String, String> getArguments();

	/**
	 * Sets the list of command line arguments passed to defcon.
	 * @param arguments
	 */
	public void setOptions(Map<String, String> arguments);
	
    ////////  
    //
    // BOT CONTROL METHODS
    //
    ////////

	/**
	 * Simplifies access to IAct. No need to use getAct().act().
	 */
    public void act(DefConCommand command);
}
