/*
 * Decompiled with CFR 0.152.
 */
package javabot;

import cz.cuni.amis.pogamut.base.communication.command.ICommandListener;
import cz.cuni.amis.pogamut.base.communication.messages.CommandMessage;
import cz.cuni.amis.pogamut.base.component.bus.IComponentBus;
import cz.cuni.amis.pogamut.base.component.bus.exception.ComponentNotRunningException;
import cz.cuni.amis.pogamut.base.component.bus.exception.ComponentPausedException;
import cz.cuni.amis.pogamut.base.utils.logging.LogCategory;
import cz.cuni.amis.pogamut.defcon.communication.messages.commands.DefConCommand;
import cz.cuni.amis.utils.ClassUtils;
import cz.cuni.amis.utils.listener.IListener;
import cz.cuni.amis.utils.listener.Listeners;
import cz.cuni.amis.utils.listener.ListenersMap;
import java.util.Collection;
import javabot.PogamutJBotSupport;

public class ActExecutor {
    private ListenersMap<Class> listeners = new ListenersMap();
    private LogCategory log;
    private IComponentBus eventBus;
    private CommandMessageListenerNotifier notifier = new CommandMessageListenerNotifier();

    public void act(CommandMessage command) throws ComponentNotRunningException, ComponentPausedException {
        if (command instanceof DefConCommand) {
            PogamutJBotSupport.addCommand((DefConCommand)command);
        }
    }

    public void addCommandListener(Class commandClass, ICommandListener listener) {
        this.listeners.add((Object)commandClass, (IListener)listener);
    }

    public boolean isCommandListening(Class commandClass, ICommandListener listener) {
        return this.listeners.isListening((Object)commandClass, (IListener)listener);
    }

    public void removeCommandListener(Class commandClass, ICommandListener listener) {
        this.listeners.remove((Object)commandClass, (IListener)listener);
    }

    public void sendCommand(DefConCommand command) {
        this.notifier.setMessage(command);
        Collection commandClasses = ClassUtils.getSubclasses(((Object)((Object)command)).getClass());
        for (Class cls : commandClasses) {
            this.listeners.notify((Object)cls, (Listeners.ListenerNotifier)this.notifier);
        }
        if (!(command instanceof DefConCommand)) {
            return;
        }
        command.perform();
    }

    private static class CommandMessageListenerNotifier
    implements Listeners.ListenerNotifier<IListener> {
        private CommandMessage msg;

        private CommandMessageListenerNotifier() {
        }

        public void setMessage(CommandMessage msg) {
            this.msg = msg;
        }

        public void notify(IListener listener) {
            listener.notify((Object)this.msg);
        }

        public Object getEvent() {
            return this.msg;
        }
    }
}

