package cz.cuni.amis.pogamut.defcon.consts;

import java.util.HashMap;
import java.util.Map;

public enum GameOption {
	
	/**
	 * Name of the game server.
	 */
	SERVER_NAME("ServerName", 0, 24, 0),
	/**
	 * Game will be advertised on the Metaserver if enabled. (Disabled, Enabled).
	 */
	ADVERTISE_ON_INTERNET("AdvertiseOnInternet", 0, 1, 1),
	/**
	 * Game will be advertised in the local network if enabled. (Disabled, Enabled)
	 */
	ADVERTISE_ON_LAN("AdvertiseOnLAN", 0, 1, 1),
	/**
	 * Default, Office Mode, Speed Defcon, Diplomacy, BigWorld, Tournament, Custom
	 */
	GAME_MODE("GameMode", 0, 6, 0),
	/**
	 * Maximum number of participating players.
	 */
	MAX_TEAMS("MaxTeams", 1, 6, 3),
	TERRITORIES_PER_TEAM("TerritoriesPerTeam", 1, 6, 1),
	CITIES_PER_TERRITORY("CitiesPerTerritory", 1, 50, 25),
	/**
	 * Maximum number of participating players.
	 */
	POPULATION_PER_TERRITORY("PopulationPerTerritory", 10, 200, 100),
	/**
	 * Distribution of population in cities (Default, Equalised, Random, TotallyRandom)
	 */
	CITY_POPULATIONS("CityPopulations", 0, 3, 0),
	/**
	 * Disable selection of territories (No, Yes)
	 */
	RANDOM_TERRITORIES("RandomTerritories", 0, 1, 0),
	/**
	 * No, Yes
	 */
	PERMIT_DEFECTION("PermitDefection", 0, 1, 1),
	/**
	 * AlwaysOff, Alliance, Selective, AlwaysOn
	 */
	RADAR_SHARING("RadarSharing", 0, 3, 1),
	/**
	 * Slowest Requested, Real Time, 5x Real Time, 10x Real Time, 20x Real Time
	 */
	GAME_SPEED("GameSpeed", 0, 4, 0),
	/**
	 * Pause, Real Time, 5x Real Time, 10x Real Time, 20x Real Time
	 */
	SLOWEST_SPEED("SlowestSpeed", 0, 4, 1),
	/**
	 * Default, Survivor, Genocide
	 */
	SCORE_MODE("ScoreMode", 0, 2, 0),
	/**
	 * Percent of remaining nukes before victory timer starts.
	 */
	VICTORY_TRIGGER("VictoryTrigger", 0, 100, 20),
	/**
	 * Duration of victory timer in minutes.
	 */
	VICTORY_TIMER("VictoryTimer", 0, 600, 45),
	/**
	 * Variable units allows the placement of units by credit (Disabled, Enabled).
	 */
	VARIABLE_UNIT_COUNT("VariableUnitCount", 0, 1, 0),
	/**
	 * Scale of the worldmap, in percent.
	 */
	WORLD_SCALE("WorldScale", 50, 200, 100),
	MAX_SPECTATORS("MaxSpectators", 0, 100, 3),
	/**
	 * Private, Public
	 */
	SPECTATOR_CHAT_CHANNEL("SpectatorChatChannel", 0, 1, 1),
	/**
	 * If enabled, teams can be switched during the game (Disabled, Enabled)
	 */
	TEAM_SWITCHING("TeamSwitching", 0, 1, 0),
	SERVER_PASSWORD("ServerPasswords", 0, 16, 0);
	
	private static Map<String, GameOption> enums = new HashMap<String, GameOption>();
	
	public static GameOption getEnum(String option) {
		return enums.get(option);
	}
	
	static {
		for (GameOption item : GameOption.values()) {
			enums.put(item.name, item);
		}
	}
	
	public final String name;
	public final int min;
	public final int max;
	public final int def;
	
	private GameOption(String name, int min, int max, int def) {
		this.name = name;
		this.min = min;
		this.max = max;
		this.def = def;
	}

	public String getName() {
		return name;
	}
	
}
