package cz.cuni.amis.pogamut.defcon.consts;

import java.util.HashMap;
import java.util.Map;

/**
 * One of the game options. Might be accessed through {@link GameInfo#GetOptionValue()}
 * and {@link GameOption}.
 * 
 * @author Radek 'Black_Hand' Pibil
 *
 */
public enum GameMode {
	
	DEFAULT(0),
	OFFICE_MODE(1),
	SPEED_DEFCON(2),
	DIPLOMACY(3),
	BIG_WORLD(4),
	TOURNAMENT(5),
	CUSTOM(6);
	
	private static Map<Integer, GameMode> enums = new HashMap<Integer, GameMode>();
	
	public static GameMode getEnum(int id) {
		return enums.get(id);
	}
	
	static {
		for (GameMode item : GameMode.values()) {
			enums.put(item.id, item);
		}
	}
	
	public final int id;
	
	private GameMode(int id) {
		this.id = id;
	}

}
