/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.base.agent.utils.runner;

import cz.cuni.amis.pogamut.base.agent.IAgent;
import cz.cuni.amis.pogamut.base.agent.impl.AbstractAgent;
import cz.cuni.amis.pogamut.base.agent.params.IAgentParameters;
import cz.cuni.amis.pogamut.base.agent.state.level0.IAgentState;
import cz.cuni.amis.pogamut.base.agent.state.level1.IAgentStateDown;
import cz.cuni.amis.pogamut.base.agent.state.level1.IAgentStateUp;
import cz.cuni.amis.pogamut.base.agent.utils.runner.test.TestAgent1;
import cz.cuni.amis.pogamut.base.agent.utils.runner.test.TestAgent1Module;
import cz.cuni.amis.pogamut.base.agent.utils.runner.test.TestAgentParams;
import cz.cuni.amis.pogamut.base.agent.utils.runner.test.TestAgentRunner;
import cz.cuni.amis.pogamut.base.factory.IAgentFactory;
import cz.cuni.amis.pogamut.base.factory.guice.GuiceAgentFactory;
import cz.cuni.amis.pogamut.base.factory.guice.GuiceAgentModule;
import cz.cuni.amis.pogamut.base.utils.Pogamut;
import cz.cuni.amis.tests.BaseTest;
import cz.cuni.amis.utils.exception.PogamutException;
import java.util.List;
import junit.framework.Assert;
import org.junit.AfterClass;
import org.junit.Test;

public class Test04_AgentRunner_UtilityMethods
extends BaseTest {
    protected int preInitHookCalled = 0;
    protected int preStartHookCalled = 0;
    protected int postStartHookCalled = 0;
    protected int postStartedHookCalled = 0;

    @AfterClass
    public static void tearDown() {
        Pogamut.getPlatform().close();
    }

    protected TestAgentRunner initAgentRunner() {
        this.preInitHookCalled = 0;
        this.preStartHookCalled = 0;
        this.postStartHookCalled = 0;
        this.postStartedHookCalled = 0;
        return new TestAgentRunner((IAgentFactory)new GuiceAgentFactory((GuiceAgentModule)new TestAgent1Module())){

            protected void preInitHook() throws PogamutException {
                super.preInitHook();
                if (Test04_AgentRunner_UtilityMethods.this.preInitHookCalled != 0) {
                    throw new RuntimeException("preInitHook() called repeatedly!");
                }
                if (Test04_AgentRunner_UtilityMethods.this.preStartHookCalled != 0) {
                    throw new RuntimeException("preInitHook() called after some preStartHook were called!");
                }
                if (Test04_AgentRunner_UtilityMethods.this.postStartHookCalled != 0) {
                    throw new RuntimeException("preInitHook() called after some postStartHook were called!");
                }
                if (Test04_AgentRunner_UtilityMethods.this.postStartedHookCalled != 0) {
                    throw new RuntimeException("preInitHook() called after postStartedHookCalled was called!");
                }
                ++Test04_AgentRunner_UtilityMethods.this.preInitHookCalled;
            }

            protected void preStartHook(AbstractAgent agent) throws PogamutException {
                super.preStartHook((IAgent)agent);
                if (agent == null) {
                    throw new RuntimeException("preStartHook called with param agent==null!");
                }
                if (Test04_AgentRunner_UtilityMethods.this.preInitHookCalled == 0) {
                    throw new RuntimeException("preStartHook() called but no preInitHook was called!");
                }
                if (Test04_AgentRunner_UtilityMethods.this.preInitHookCalled != 1) {
                    throw new RuntimeException("preStartHook() called when more than one preInitHook was called!");
                }
                if (Test04_AgentRunner_UtilityMethods.this.postStartedHookCalled != 0) {
                    throw new RuntimeException("preStartHook() called after postStartedHookCalled was called!");
                }
                ++Test04_AgentRunner_UtilityMethods.this.preStartHookCalled;
            }

            protected void postStartHook(AbstractAgent agent) throws PogamutException {
                super.postStartHook((IAgent)agent);
                ++Test04_AgentRunner_UtilityMethods.this.postStartHookCalled;
                if (agent == null) {
                    throw new RuntimeException("postStartHook called with param agent==null!");
                }
                if (Test04_AgentRunner_UtilityMethods.this.preInitHookCalled == 0) {
                    throw new RuntimeException("postStartHook() called but no preInitHook was called!");
                }
                if (Test04_AgentRunner_UtilityMethods.this.preInitHookCalled != 1) {
                    throw new RuntimeException("postStartHook() called when more than one preInitHook was called!");
                }
                if (Test04_AgentRunner_UtilityMethods.this.preStartHookCalled != Test04_AgentRunner_UtilityMethods.this.postStartHookCalled) {
                    throw new RuntimeException("preStartHook num. of calls != postStartHook num of calls!");
                }
                if (Test04_AgentRunner_UtilityMethods.this.postStartedHookCalled != 0) {
                    throw new RuntimeException("postStartHook() called after postStartedHookCalled was called!");
                }
            }

            protected void postStartedHook(List<AbstractAgent> agents) {
                super.postStartedHook(agents);
                for (int i = 0; i < agents.size(); ++i) {
                    if (agents.get(i) == null) {
                        throw new RuntimeException("postStartedHook called with param agents[" + i + "] == null!");
                    }
                    if (Test04_AgentRunner_UtilityMethods.this.preInitHookCalled == 0) {
                        throw new RuntimeException("postStartedHook() called but no preInitHook was called!");
                    }
                    if (Test04_AgentRunner_UtilityMethods.this.preInitHookCalled != 1) {
                        throw new RuntimeException("postStartedHook() called when more than one preInitHook was called!");
                    }
                    if (Test04_AgentRunner_UtilityMethods.this.postStartedHookCalled != 0) {
                        throw new RuntimeException("postStartedHook() called repeatedly!");
                    }
                    if (Test04_AgentRunner_UtilityMethods.this.preStartHookCalled == Test04_AgentRunner_UtilityMethods.this.postStartHookCalled) continue;
                    throw new RuntimeException("preStartHook num. of calls != postStartHook num of calls!");
                }
                ++Test04_AgentRunner_UtilityMethods.this.postStartedHookCalled;
            }
        };
    }

    protected void checkAgentRunnerCalls(int numAgents) {
        System.out.println("Checking agent runner calls...");
        if (this.preInitHookCalled == 0) {
            throw new RuntimeException("preInitHook() was not called at all!");
        }
        if (this.preInitHookCalled != 1) {
            throw new RuntimeException("preInitHook() was called more than once!");
        }
        if (this.preStartHookCalled != numAgents) {
            throw new RuntimeException(numAgents + " started, but preStartHook was called only " + this.preStartHookCalled + "x!");
        }
        if (this.postStartHookCalled != numAgents) {
            throw new RuntimeException(numAgents + " started, but postStartHook was called only " + this.postStartHookCalled + "x!");
        }
        if (this.preStartHookCalled != this.postStartHookCalled) {
            throw new RuntimeException("preStartHook num. of calls != postStartHook num of calls!");
        }
        if (this.postStartedHookCalled == 0) {
            throw new RuntimeException("postStartedHook() was not called at all!");
        }
        if (this.postStartedHookCalled != 1) {
            throw new RuntimeException("postStartedHook() was called more than once!");
        }
        System.out.println("OK");
    }

    @Test
    public void test_start1Agent() {
        TestAgentRunner runner = this.initAgentRunner();
        System.out.println("Starting 1 agent...");
        IAgent agent = runner.startAgent();
        System.out.println("Checking agent class...");
        Assert.assertTrue((boolean)(agent instanceof TestAgent1));
        System.out.println("OK");
        System.out.println("Checking agent running...");
        Assert.assertTrue((boolean)((IAgentState)agent.getState().getFlag()).isState(new Class[]{IAgentStateUp.class}));
        System.out.println("OK");
        System.out.println("Stopping 1 agent...");
        agent.stop();
        System.out.println("Checking agent stopped...");
        Assert.assertTrue((boolean)((IAgentState)agent.getState().getFlag()).isState(new Class[]{IAgentStateDown.class}));
        System.out.println("OK");
        this.checkAgentRunnerCalls(1);
        System.out.println("---/// TEST OK ///---");
    }

    @Test
    public void test_start5Agents() {
        int i;
        TestAgentRunner runner = this.initAgentRunner();
        int NUM_AGENTS = 5;
        System.out.println("Starting " + NUM_AGENTS + " agents...");
        List agents = runner.startAgents(NUM_AGENTS);
        System.out.println("Checking agents classes...");
        for (i = 0; i < NUM_AGENTS; ++i) {
            Assert.assertTrue((boolean)(agents.get(i) instanceof TestAgent1));
        }
        System.out.println("OK");
        System.out.println("Checking agents running...");
        for (i = 0; i < NUM_AGENTS; ++i) {
            Assert.assertTrue((boolean)((IAgentState)((AbstractAgent)agents.get(i)).getState().getFlag()).isState(new Class[]{IAgentStateUp.class}));
        }
        System.out.println("OK");
        System.out.println("Stopping " + NUM_AGENTS + " agents...");
        for (i = 0; i < NUM_AGENTS; ++i) {
            ((AbstractAgent)agents.get(i)).stop();
        }
        System.out.println("Checking agents stopped...");
        for (i = 0; i < NUM_AGENTS; ++i) {
            Assert.assertTrue((boolean)((IAgentState)((AbstractAgent)agents.get(i)).getState().getFlag()).isState(new Class[]{IAgentStateDown.class}));
        }
        System.out.println("OK");
        this.checkAgentRunnerCalls(NUM_AGENTS);
        System.out.println("---/// TEST OK ///---");
    }

    @Test
    public void test_start5AgentsWithDifferentParams() {
        int i;
        TestAgentRunner runner = this.initAgentRunner();
        int NUM_AGENTS = 5;
        System.out.println("Starting " + NUM_AGENTS + " agents with different parameters...");
        TestAgentParams[] params = new TestAgentParams[NUM_AGENTS];
        for (int i2 = 0; i2 < NUM_AGENTS; ++i2) {
            params[i2] = new TestAgentParams(i2);
        }
        List agents = runner.startAgents((IAgentParameters[])params);
        System.out.println("Checking agents classes...");
        for (i = 0; i < NUM_AGENTS; ++i) {
            Assert.assertTrue((boolean)(agents.get(i) instanceof TestAgent1));
        }
        System.out.println("OK");
        System.out.println("Checking agents running...");
        for (i = 0; i < NUM_AGENTS; ++i) {
            Assert.assertTrue((boolean)((IAgentState)((AbstractAgent)agents.get(i)).getState().getFlag()).isState(new Class[]{IAgentStateUp.class}));
        }
        System.out.println("OK");
        System.out.println("Check agents' parameters...");
        for (i = 0; i < NUM_AGENTS; ++i) {
            Assert.assertTrue((((TestAgent1)((Object)agents.get(i))).getParam() == i ? 1 : 0) != 0);
        }
        System.out.println("OK");
        System.out.println("Stopping " + NUM_AGENTS + " agents...");
        for (i = 0; i < NUM_AGENTS; ++i) {
            ((AbstractAgent)agents.get(i)).stop();
        }
        System.out.println("Checking agents stopped...");
        for (i = 0; i < NUM_AGENTS; ++i) {
            Assert.assertTrue((boolean)((IAgentState)((AbstractAgent)agents.get(i)).getState().getFlag()).isState(new Class[]{IAgentStateDown.class}));
        }
        System.out.println("OK");
        this.checkAgentRunnerCalls(NUM_AGENTS);
        System.out.println("---/// TEST OK ///---");
    }

    public static void main(String[] args) {
        Test04_AgentRunner_UtilityMethods test = new Test04_AgentRunner_UtilityMethods();
        test.test_start1Agent();
        test.test_start5Agents();
        test.test_start5AgentsWithDifferentParams();
        Test04_AgentRunner_UtilityMethods.tearDown();
    }
}

