/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.multi.worldview.objects;

import cz.cuni.amis.pogamut.base.communication.worldview.object.WorldObjectId;
import cz.cuni.amis.pogamut.multi.agent.ITeamId;
import cz.cuni.amis.pogamut.multi.communication.translator.event.ICompositeWorldObjectUpdatedEvent;
import cz.cuni.amis.pogamut.multi.communication.translator.event.ILocalWorldObjectUpdatedEvent;
import cz.cuni.amis.pogamut.multi.communication.translator.event.ISharedWorldObjectUpdatedEvent;
import cz.cuni.amis.pogamut.multi.communication.translator.event.IStaticWorldObjectUpdatedEvent;
import cz.cuni.amis.pogamut.multi.communication.worldview.object.ICompositeWorldObject;
import cz.cuni.amis.pogamut.multi.worldview.objects.TestLocalObject;
import cz.cuni.amis.pogamut.multi.worldview.objects.TestSharedObject;
import cz.cuni.amis.pogamut.multi.worldview.objects.TestSharedObjectImpl;
import cz.cuni.amis.pogamut.multi.worldview.objects.TestStaticObject;

public abstract class TestCompositeObject
implements ICompositeWorldObject {
    protected WorldObjectId id;

    protected TestCompositeObject(WorldObjectId id) {
        this.id = id;
    }

    public WorldObjectId getId() {
        return this.id;
    }

    public abstract String getLocalString();

    public abstract long getLocalLong();

    public abstract String getStaticString();

    public abstract long getStaticLong();

    public abstract String getSharedString();

    public abstract long getSharedLong();

    public ICompositeWorldObjectUpdatedEvent createUpdateEvent(long time, ITeamId teamId) {
        return new TestCompositeObjectUpdatedEvent(this, time, teamId);
    }

    public static class TestCompositeObjectUpdatedEvent
    implements ICompositeWorldObjectUpdatedEvent {
        private TestCompositeObject data;
        private long time;
        private ITeamId teamId;

        public TestCompositeObjectUpdatedEvent(TestCompositeObject data, long time, ITeamId teamId) {
            this.data = data;
            this.time = time;
            this.teamId = teamId;
        }

        public long getSimTime() {
            return this.time;
        }

        public WorldObjectId getId() {
            return this.data.getId();
        }

        public ILocalWorldObjectUpdatedEvent getLocalEvent() {
            return new TestLocalObject.TestLocalObjectUpdatedEvent((TestLocalObject)this.data.getLocal(), this.time);
        }

        public ISharedWorldObjectUpdatedEvent getSharedEvent() {
            return new TestSharedObjectImpl.TestSharedObjectUpdatedEvent((TestSharedObject)this.data.getShared(), this.time, this.teamId);
        }

        public IStaticWorldObjectUpdatedEvent getStaticEvent() {
            return new TestStaticObject.TestStaticObjectUpdatedEvent((TestStaticObject)this.data.getStatic(), this.time);
        }
    }
}

