/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.multi.worldview.objects;

import cz.cuni.amis.pogamut.base.communication.translator.event.IWorldObjectUpdateResult;
import cz.cuni.amis.pogamut.base.communication.worldview.object.IWorldObject;
import cz.cuni.amis.pogamut.base.communication.worldview.object.WorldObjectId;
import cz.cuni.amis.pogamut.multi.communication.translator.event.IStaticWorldObjectUpdatedEvent;
import cz.cuni.amis.pogamut.multi.communication.worldview.object.IStaticWorldObject;
import cz.cuni.amis.pogamut.multi.worldview.objects.TestCompositeObject;
import cz.cuni.amis.pogamut.multi.worldview.objects.TestStaticObjectImpl;
import cz.cuni.amis.utils.exception.PogamutException;

public abstract class TestStaticObject
implements IStaticWorldObject {
    protected WorldObjectId id;
    protected long simTime;

    public abstract String getStaticString();

    public abstract long getStaticLong();

    protected TestStaticObject(WorldObjectId id, long simTime) {
        this.id = id;
        this.simTime = simTime;
    }

    public WorldObjectId getId() {
        return this.id;
    }

    public long getSimTime() {
        return this.simTime;
    }

    public Class getCompositeClass() {
        return TestCompositeObject.class;
    }

    public String toString() {
        return "TestStaticObject[id=" + this.getId() + ", time=" + this.getSimTime() + ", staticString=" + this.getStaticString() + ", staticLong=" + this.getStaticLong() + "]";
    }

    public IStaticWorldObjectUpdatedEvent createUpdateEvent(long time) {
        return new TestStaticObjectUpdatedEvent(this, time);
    }

    public static class TestStaticObjectUpdatedEvent
    implements IStaticWorldObjectUpdatedEvent {
        private long time;
        private TestStaticObject obj;

        public TestStaticObjectUpdatedEvent(TestStaticObject object, long time) {
            this.time = time;
            this.obj = object;
        }

        public long getSimTime() {
            return this.time;
        }

        public IWorldObjectUpdateResult<IStaticWorldObject> update(IStaticWorldObject object) {
            if (object == null) {
                TestStaticObjectImpl impl = new TestStaticObjectImpl(this.obj);
                this.obj = impl;
                return new IWorldObjectUpdateResult.WorldObjectUpdateResult(IWorldObjectUpdateResult.Result.CREATED, (IWorldObject)impl);
            }
            if (object instanceof TestStaticObjectImpl) {
                TestStaticObjectImpl updatee = (TestStaticObjectImpl)object;
                boolean updated = false;
                if (updatee.getStaticLong() != this.obj.getStaticLong()) {
                    updated = true;
                }
                if (!updatee.getStaticString().equals(this.obj.getStaticString())) {
                    updated = true;
                }
                if (!updated) {
                    updatee.simTime = this.time;
                    this.obj = updatee;
                    return new IWorldObjectUpdateResult.WorldObjectUpdateResult(IWorldObjectUpdateResult.Result.SAME, (IWorldObject)this.obj);
                }
                throw new PogamutException("Trying to change a staticWorldObjec " + this.obj.getId() + " .", (Object)this);
            }
            throw new IllegalArgumentException("Wrong object class provided. Expected TestStaticObjectImpl, instead got " + object.getClass());
        }

        public WorldObjectId getId() {
            return this.obj.getId();
        }

        public String toString() {
            return "TestStaticObjectUpdatedEvent[id=" + this.getId() + ", time=" + this.getSimTime() + "]";
        }
    }
}

