/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.base.agent.utils.runner;

import cz.cuni.amis.pogamut.base.agent.IAgent;
import cz.cuni.amis.pogamut.base.agent.impl.AbstractAgent;
import cz.cuni.amis.pogamut.base.agent.params.IAgentParameters;
import cz.cuni.amis.pogamut.base.agent.utils.runner.IAgentDescriptor;
import cz.cuni.amis.pogamut.base.agent.utils.runner.IMultipleAgentRunner;
import cz.cuni.amis.pogamut.base.agent.utils.runner.impl.AgentDescriptor;
import cz.cuni.amis.pogamut.base.agent.utils.runner.test.TestAgent1Module;
import cz.cuni.amis.pogamut.base.agent.utils.runner.test.TestAgent2Module;
import cz.cuni.amis.pogamut.base.agent.utils.runner.test.TestAgentParams;
import cz.cuni.amis.pogamut.base.agent.utils.runner.test.TestMultipleAgentRunner;
import cz.cuni.amis.pogamut.base.factory.guice.GuiceAgentModule;
import cz.cuni.amis.tests.BaseTest;
import cz.cuni.amis.utils.exception.PogamutException;
import java.util.List;
import junit.framework.Assert;
import org.junit.Test;

public class Test16_MultipleAgentRunner_Main_AgentFailure
extends BaseTest {
    static final int NUM_AGENTS = 5;

    protected IMultipleAgentRunner initAgentRunner() {
        return new TestMultipleAgentRunner(){
            private int postStartHookCalled;

            protected void postStartHook(AbstractAgent agent) {
                super.postStartHook((IAgent)agent);
                ++this.postStartHookCalled;
                if (this.postStartHookCalled == 10) {
                    agent.kill();
                }
            }
        }.setMain(true);
    }

    public IAgentDescriptor[] initDescriptors(int numAgents) {
        int i;
        IAgentDescriptor[] result = new IAgentDescriptor[2];
        AgentDescriptor desc = new AgentDescriptor();
        desc.setAgentModule((GuiceAgentModule)new TestAgent1Module());
        for (i = 0; i < numAgents; ++i) {
            desc.addParams(new IAgentParameters[]{new TestAgentParams(i)});
        }
        result[0] = desc;
        desc = new AgentDescriptor();
        desc.setAgentModule((GuiceAgentModule)new TestAgent2Module());
        for (i = 0; i < numAgents; ++i) {
            desc.addParams(new IAgentParameters[]{new TestAgentParams(i)});
        }
        result[1] = desc;
        return result;
    }

    @Test
    public void test_start5Agents() {
        IMultipleAgentRunner runner = this.initAgentRunner();
        System.out.println("Starting 5 agents...");
        boolean exception = false;
        try {
            List agents = runner.startAgents(this.initDescriptors(5));
        }
        catch (PogamutException e) {
            exception = true;
            System.out.println("PogamutException caught (as one of the agent has failed)...");
        }
        System.out.println("Checking whether the exception has been thrown...");
        Assert.assertTrue((String)"No exception thrown due to agent failure!", (boolean)exception);
        System.out.println("OK");
        System.out.println("---/// TEST OK ///---");
        System.out.println("");
        System.out.println("IF THE TEST DOES NOT TERMINATE ITSELF AFTER THIS POINT - IT MEANS THAT 'main' FEATURE OF THE IMultipleAgentRunner IS BROKEN!!!");
    }

    public static void main(String[] args) {
        Test16_MultipleAgentRunner_Main_AgentFailure test = new Test16_MultipleAgentRunner_Main_AgentFailure();
        test.test_start5Agents();
    }
}

