/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.base.agent.module;

import cz.cuni.amis.pogamut.base.agent.IAgent;
import cz.cuni.amis.pogamut.base.agent.IAgentId;
import cz.cuni.amis.pogamut.base.agent.impl.AbstractAgent;
import cz.cuni.amis.pogamut.base.agent.impl.AgentId;
import cz.cuni.amis.pogamut.base.agent.module.IAgentLogic;
import cz.cuni.amis.pogamut.base.agent.module.LogicModule;
import cz.cuni.amis.pogamut.base.component.IComponent;
import cz.cuni.amis.pogamut.base.component.bus.ComponentBus;
import cz.cuni.amis.pogamut.base.component.bus.IComponentBus;
import cz.cuni.amis.pogamut.base.component.controller.ComponentDependencies;
import cz.cuni.amis.pogamut.base.component.controller.ComponentDependencyType;
import cz.cuni.amis.pogamut.base.component.stub.component.ComponentStub;
import cz.cuni.amis.pogamut.base.utils.logging.AgentLogger;
import cz.cuni.amis.pogamut.base.utils.logging.IAgentLogger;
import cz.cuni.amis.pogamut.base.utils.logging.LogCategory;
import cz.cuni.amis.tests.BaseTest;
import cz.cuni.amis.utils.flag.Flag;
import cz.cuni.amis.utils.flag.FlagListener;
import java.util.logging.Level;
import java.util.logging.Logger;
import junit.framework.Assert;
import org.junit.Test;

public class Test01_LogicModule
extends BaseTest {
    private Flag<Boolean> shutdown = new Flag((Object)false);
    private boolean init = false;
    private int logicCalled = 0;
    private Flag<Boolean> logic = new Flag((Object)false);
    private Flag<Boolean> beforeLogic = new Flag((Object)false);

    @Test
    public void test() {
        AgentId agentId = new AgentId("Test01_LogicModule");
        AgentLogger logger = new AgentLogger((IAgentId)agentId);
        logger.addDefaultConsoleHandler();
        logger.setLevel(Level.ALL);
        ComponentBus bus = new ComponentBus((IAgentLogger)logger);
        final ComponentStub starter = new ComponentStub((IAgentLogger)logger, (IComponentBus)bus);
        final LogCategory log = logger.getCategory("Logic");
        FlagListener<Boolean> logicListener = new FlagListener<Boolean>(){

            public void flagChanged(Boolean changedValue) {
                if (changedValue.booleanValue()) {
                    starter.getController().manualStop("Logic sensed.");
                }
            }
        };
        this.logic.addListener((FlagListener)logicListener);
        IAgentLogic agentLogic = new IAgentLogic(){

            public long getLogicInitializeTime() {
                return 0L;
            }

            public long getLogicShutdownTime() {
                return 0L;
            }

            public void logic() {
                ++Test01_LogicModule.this.logicCalled;
                if (log.isLoggable(Level.INFO)) {
                    log.info("Logic called: " + Test01_LogicModule.this.logicCalled + "x");
                }
                if (Test01_LogicModule.this.logicCalled == 5) {
                    Test01_LogicModule.this.logic.setFlag((Object)true);
                    return;
                }
                if (Test01_LogicModule.this.logicCalled > 5) {
                    Assert.fail((String)"logic should be called only 5x");
                }
            }

            public void logicInitialize(LogicModule logicModule) {
                if (log.isLoggable(Level.INFO)) {
                    log.info("Logic initialize.");
                }
                if (Test01_LogicModule.this.init) {
                    Assert.fail((String)"logicInitialize could not be called twice");
                }
            }

            public void logicShutdown() {
                if (log.isLoggable(Level.INFO)) {
                    log.info("Logic shutdown.");
                }
                if (((Boolean)Test01_LogicModule.this.shutdown.getFlag()).booleanValue()) {
                    Assert.fail((String)"logicShutdown() could not be called twice");
                }
                Test01_LogicModule.this.shutdown.setFlag((Object)true);
            }

            public void beforeFirstLogic() {
                if (log.isLoggable(Level.INFO)) {
                    log.info("BeforeLogic.");
                }
                if (((Boolean)Test01_LogicModule.this.beforeLogic.getFlag()).booleanValue()) {
                    Assert.fail((String)"beforeFirstLogic() could not be called twice");
                }
                Test01_LogicModule.this.beforeLogic.setFlag((Object)true);
            }
        };
        LogicModule logicModule = new LogicModule((IAgent)new AbstractAgent((IAgentId)agentId, (IComponentBus)bus, (IAgentLogger)logger){}, agentLogic, (Logger)log, new ComponentDependencies(ComponentDependencyType.STARTS_WITH).add((IComponent)starter));
        for (int i = 0; i < 20; ++i) {
            System.out.println("---((( Iteration " + (i + 1) + " / 20 )))---");
            this.init = false;
            this.logic.setFlag((Object)false);
            this.shutdown.setFlag((Object)false);
            this.beforeLogic.setFlag((Object)false);
            this.logicCalled = 0;
            starter.getController().manualStart("Starting the logic.");
            Boolean result = (Boolean)this.shutdown.waitFor(10000L, (Object[])new Boolean[]{true});
            if (result == null || !result.booleanValue()) {
                this.testFailed("logic should have terminated");
            }
            if (!((Boolean)this.beforeLogic.getFlag()).booleanValue()) {
                this.testFailed("beforeFirstLogic() not called!");
            }
            if (!((Boolean)this.logic.getFlag()).booleanValue()) {
                this.testFailed("logic() not called!");
            }
            if (this.logicCalled == 5) continue;
            this.testFailed("logic() should have been called only 5x not " + this.logicCalled + "x !");
        }
        System.out.println("---/// TEST OK ///---");
    }

    public static void main(String[] args) {
        Test01_LogicModule test = new Test01_LogicModule();
        test.test();
    }
}

