/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.multi.communication.worldview.impl;

import cz.cuni.amis.pogamut.base.agent.IAgentId;
import cz.cuni.amis.pogamut.base.communication.worldview.event.IWorldEvent;
import cz.cuni.amis.pogamut.base.communication.worldview.event.IWorldEventListener;
import cz.cuni.amis.pogamut.base.communication.worldview.object.IWorldObjectEvent;
import cz.cuni.amis.pogamut.base.communication.worldview.object.IWorldObjectEventListener;
import cz.cuni.amis.pogamut.base.communication.worldview.object.WorldObjectId;
import cz.cuni.amis.pogamut.base.component.controller.ComponentDependencies;
import cz.cuni.amis.pogamut.base.component.controller.ISharedComponentControlHelper;
import cz.cuni.amis.pogamut.base.component.controller.ISharedComponentController;
import cz.cuni.amis.pogamut.base.component.controller.SharedComponentControlHelper;
import cz.cuni.amis.pogamut.base.component.controller.SharedComponentController;
import cz.cuni.amis.pogamut.base.component.lifecyclebus.ILifecycleBus;
import cz.cuni.amis.pogamut.base.utils.guice.AgentTeamScoped;
import cz.cuni.amis.pogamut.multi.agent.ITeamId;
import cz.cuni.amis.pogamut.multi.communication.worldview.ILocalWorldView;
import cz.cuni.amis.pogamut.multi.communication.worldview.ISharedWorldView;
import cz.cuni.amis.pogamut.multi.communication.worldview.object.ISharedProperty;
import cz.cuni.amis.pogamut.multi.communication.worldview.object.ISharedWorldObject;
import cz.cuni.amis.pogamut.multi.communication.worldview.object.IStaticWorldObject;
import cz.cuni.amis.pogamut.multi.communication.worldview.property.PropertyId;
import cz.cuni.amis.pogamut.multi.utils.timekey.TimeKey;
import cz.cuni.amis.pogamut.multi.utils.timekey.TimeKeyManager;
import cz.cuni.amis.utils.ClassUtils;
import cz.cuni.amis.utils.exception.PogamutException;
import cz.cuni.amis.utils.listener.IListener;
import cz.cuni.amis.utils.listener.Listeners;
import cz.cuni.amis.utils.listener.ListenersMap;
import cz.cuni.amis.utils.maps.HashTriMap;
import cz.cuni.amis.utils.maps.LazyMap;
import cz.cuni.amis.utils.maps.WeakHashQuadMap;
import cz.cuni.amis.utils.maps.WeakHashTriMap;
import cz.cuni.amis.utils.token.Token;
import cz.cuni.amis.utils.token.Tokens;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.logging.Level;
import java.util.logging.Logger;

@AgentTeamScoped
public abstract class AbstractSharedWorldView
implements ISharedWorldView {
    public static final Token COMPONENT_ID = Tokens.get((String)"AbstractSharedWorldView");
    protected HashMap<IAgentId, ILocalWorldView> localWorldViews = new HashMap();
    protected WeakHashQuadMap<TimeKey, ITeamId, WorldObjectId, PropertyId, ISharedProperty> sharedProperties = new WeakHashQuadMap(8, 8, 32, 8);
    protected Map<TimeKey, Map<ITeamId, Map<WorldObjectId, Map<PropertyId, ISharedProperty>>>> syncSharedProperties = Collections.synchronizedMap(this.sharedProperties);
    protected HashTriMap<ITeamId, WorldObjectId, PropertyId, ISharedProperty> currentSharedProperties = new HashTriMap(8, 32, 8);
    protected Map<ITeamId, Map<WorldObjectId, Map<PropertyId, ISharedProperty>>> syncCurrentSharedProperties = Collections.synchronizedMap(this.currentSharedProperties);
    protected Map<WorldObjectId, IStaticWorldObject> staticWorldObjects = Collections.synchronizedMap(new HashMap(32));
    protected WeakHashTriMap<TimeKey, ITeamId, WorldObjectId, ISharedWorldObject> sharedWorldObjects = new WeakHashTriMap(8, 8, 32);
    protected Map<TimeKey, Map<ITeamId, Map<WorldObjectId, ISharedWorldObject>>> syncSharedWorldObjects = Collections.synchronizedMap(this.sharedWorldObjects);
    protected HashMap<WorldObjectId, Class> idClassMap = new HashMap();
    protected Map<WorldObjectId, Class> syncIdClassMap = Collections.synchronizedMap(this.idClassMap);
    private ListenerNotifier notifier = new ListenerNotifier();
    private ListenersMap<Class> eventListeners = new ListenersMap();
    private ListenersMap<Class> objectsListeners = new ListenersMap();
    private Map<Class, ListenersMap<Class>> objectEventListeners = Collections.synchronizedMap(new LazyMap<Class, ListenersMap<Class>>(){

        protected ListenersMap<Class> create(Class key) {
            return new ListenersMap();
        }
    });
    private ListenersMap<WorldObjectId> specificObjectListeners = new ListenersMap();
    private Map<WorldObjectId, ListenersMap<Class>> specificObjectEventListeners = Collections.synchronizedMap(new LazyMap<WorldObjectId, ListenersMap<Class>>(){

        protected ListenersMap<Class> create(WorldObjectId key) {
            return new ListenersMap();
        }
    });
    private boolean raiseEventProcessing = false;
    private Queue<IWorldEvent> raiseEventsList = new ConcurrentLinkedQueue<IWorldEvent>();
    protected Logger log;
    protected ISharedComponentController<ISharedWorldView> controller;
    protected ISharedComponentControlHelper control = new SharedComponentControlHelper(){

        @Override
        public void start() throws PogamutException {
            AbstractSharedWorldView.this.start();
        }

        @Override
        public void prePause() throws PogamutException {
            AbstractSharedWorldView.this.prePause();
        }

        @Override
        public void pause() throws PogamutException {
            AbstractSharedWorldView.this.pause();
        }

        @Override
        public void resume() throws PogamutException {
            AbstractSharedWorldView.this.resume();
        }

        @Override
        public void preStop() throws PogamutException {
            AbstractSharedWorldView.this.preStop();
        }

        @Override
        public void stop() throws PogamutException {
            AbstractSharedWorldView.this.stop();
        }

        @Override
        public void kill() {
            AbstractSharedWorldView.this.kill();
        }

        @Override
        public void reset() {
            AbstractSharedWorldView.this.reset();
        }
    };

    @Override
    public void registerLocalWorldView(ILocalWorldView localWV, ILifecycleBus bus) {
        this.localWorldViews.put(localWV.getAgentId(), localWV);
        this.addComponentBus(localWV.getAgentId(), bus, new ComponentDependencies());
    }

    protected ISharedProperty getSharedProperty(PropertyId id, ITeamId teamId, TimeKey time) {
        ISharedProperty result = this.syncSharedProperties.get(time).get(teamId).get(id.getWorldObjectId()).get(id);
        if (result != null) {
            return result;
        }
        return (ISharedProperty)this.currentSharedProperties.get((Object)teamId, (Object)id.getWorldObjectId(), (Object)id);
    }

    protected Collection<ISharedProperty> getSharedProperties(WorldObjectId objectId, ITeamId teamId, TimeKey time) {
        LinkedList<ISharedProperty> lst = new LinkedList<ISharedProperty>();
        Set<PropertyId> set = this.syncCurrentSharedProperties.get(teamId).get(objectId).keySet();
        for (PropertyId propId : set) {
            lst.add(this.getSharedProperty(propId, teamId, time));
        }
        return lst;
    }

    protected abstract ISharedWorldObject createSharedObject(Class var1, WorldObjectId var2, ITeamId var3, TimeKey var4);

    @Override
    public ISharedWorldObject getShared(ITeamId teamId, WorldObjectId objectId, TimeKey time) {
        ISharedWorldObject value = (ISharedWorldObject)this.sharedWorldObjects.get((Object)time, (Object)teamId, (Object)objectId);
        if (value != null) {
            return value;
        }
        Class msgClass = this.syncIdClassMap.get(objectId);
        value = this.createSharedObject(msgClass, objectId, teamId, time);
        if (value == null) {
            throw new PogamutException("SharedObject for objectId=" + objectId + ", teamId = " + teamId + ", time = " + time + ", could not have been created, createSharedObject(objectId, teamId, time) returned null!", (Object)this);
        }
        this.sharedWorldObjects.put((Object)time, (Object)teamId, (Object)objectId, (Object)value);
        return value;
    }

    @Override
    public IStaticWorldObject getStatic(WorldObjectId id) {
        return this.staticWorldObjects.get(id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addStaticWorldObject(IStaticWorldObject object) {
        Map<WorldObjectId, IStaticWorldObject> map = this.staticWorldObjects;
        synchronized (map) {
            this.staticWorldObjects.put(object.getId(), object);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeStaticWorldObject(WorldObjectId id) {
        Map<WorldObjectId, IStaticWorldObject> map = this.staticWorldObjects;
        synchronized (map) {
            this.staticWorldObjects.remove(id);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeStaticWorldObject(IStaticWorldObject object) {
        Map<WorldObjectId, IStaticWorldObject> map = this.staticWorldObjects;
        synchronized (map) {
            this.staticWorldObjects.remove(object.getId());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addSharedProperty(ISharedProperty property, ITeamId teamId) {
        Map<ITeamId, Map<WorldObjectId, Map<PropertyId, ISharedProperty>>> map = this.syncCurrentSharedProperties;
        synchronized (map) {
            this.syncCurrentSharedProperties.get(teamId).get(property.getObjectId()).put(property.getPropertyId(), property);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addSharedProperty(ISharedProperty property) {
        Map<ITeamId, Map<WorldObjectId, Map<PropertyId, ISharedProperty>>> map = this.syncCurrentSharedProperties;
        synchronized (map) {
            for (ITeamId team : this.syncCurrentSharedProperties.keySet()) {
                this.addSharedProperty(property, team);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeSharedProperty(ISharedProperty property, ITeamId teamId) {
        if (teamId == null) {
            this.removeSharedProperty(property);
            return;
        }
        Map<ITeamId, Map<WorldObjectId, Map<PropertyId, ISharedProperty>>> map = this.syncCurrentSharedProperties;
        synchronized (map) {
            this.syncCurrentSharedProperties.get(teamId).get(property.getObjectId()).remove(property.getPropertyId());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeSharedProperty(ISharedProperty property) {
        Map<ITeamId, Map<WorldObjectId, Map<PropertyId, ISharedProperty>>> map = this.syncCurrentSharedProperties;
        synchronized (map) {
            for (ITeamId team : this.syncCurrentSharedProperties.keySet()) {
                this.removeSharedProperty(property, team);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addSharedWorldObject(ISharedWorldObject object) {
        Map<ITeamId, Map<WorldObjectId, Map<PropertyId, ISharedProperty>>> map = this.syncCurrentSharedProperties;
        synchronized (map) {
            for (ISharedProperty property : object.getProperties().values()) {
                this.addSharedProperty(property);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addOldSharedProperty(ISharedProperty property, ITeamId teamId, long eventTime) {
        for (Long t : TimeKeyManager.get().getHeldKeys()) {
            Map props;
            if (t >= eventTime) continue;
            TimeKey timeKey = TimeKey.get(t);
            Map map = props = this.sharedProperties.get((Object)timeKey, (Object)teamId, (Object)property.getObjectId());
            synchronized (map) {
                ISharedProperty old = (ISharedProperty)props.get(property.getPropertyId());
                if (old == null) {
                    props.put(property.getPropertyId(), property);
                }
            }
        }
    }

    public AbstractSharedWorldView(Logger logger) {
        this.log = logger;
        this.controller = new SharedComponentController<AbstractSharedWorldView>(this, this.control, logger);
    }

    @Override
    public void addComponentBus(IAgentId agentId, ILifecycleBus bus, ComponentDependencies dependencies) {
        this.controller.addComponentBus(agentId, bus, dependencies);
    }

    @Override
    public void removeComponentBus(IAgentId agentId, ILifecycleBus bus) {
        this.controller.removeComponentBus(agentId, bus);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void cleanUp() {
        Object object = this.sharedProperties;
        synchronized (object) {
            this.sharedProperties.clear();
        }
        object = this.staticWorldObjects;
        synchronized (object) {
            this.staticWorldObjects.clear();
        }
        object = this.sharedWorldObjects;
        synchronized (object) {
            this.sharedWorldObjects.clear();
        }
        object = this.raiseEventsList;
        synchronized (object) {
            this.raiseEventsList.clear();
        }
    }

    protected void start() {
        this.cleanUp();
    }

    protected void prePause() {
    }

    protected void pause() {
    }

    protected void resume() {
    }

    protected void preStop() {
    }

    protected void stop() {
        this.cleanUp();
    }

    protected void kill() {
        this.cleanUp();
    }

    protected void reset() {
        this.cleanUp();
    }

    protected boolean isRunning() {
        return this.controller.isRunning();
    }

    protected boolean isPaused() {
        return this.controller.isPaused();
    }

    public Token getComponentId() {
        return COMPONENT_ID;
    }

    @Override
    public void addEventListener(Class<?> event, IWorldEventListener<?> listener) {
        this.eventListeners.add(event, listener);
    }

    @Override
    public void addObjectListener(Class<?> objectClass, IWorldObjectEventListener<?, ?> listener) {
        this.objectsListeners.add(objectClass, listener);
    }

    @Override
    public void addObjectListener(Class<?> objectClass, Class<?> eventClass, IWorldObjectEventListener<?, ?> listener) {
        ListenersMap<Class> listeners = this.objectEventListeners.get(eventClass);
        listeners.add(objectClass, listener);
    }

    @Override
    public void addObjectListener(WorldObjectId objectId, IWorldObjectEventListener<?, ?> listener) {
        this.specificObjectListeners.add((Object)objectId, listener);
    }

    @Override
    public void addObjectListener(WorldObjectId objectId, Class<?> eventClass, IWorldObjectEventListener<?, ?> listener) {
        ListenersMap<Class> listeners = this.specificObjectEventListeners.get(objectId);
        listeners.add(eventClass, listener);
    }

    @Override
    public boolean isListening(Class<?> eventClass, IWorldEventListener<?> listener) {
        return this.eventListeners.isListening(eventClass, listener);
    }

    @Override
    public boolean isListening(Class<?> objectClass, IWorldObjectEventListener<?, ?> listener) {
        return this.objectsListeners.isListening(listener);
    }

    @Override
    public boolean isListening(Class<?> objectClass, Class<?> eventClass, IWorldObjectEventListener<?, ?> listener) {
        if (this.objectEventListeners.containsKey(objectClass)) {
            return this.objectEventListeners.get(eventClass).isListening(objectClass, listener);
        }
        return false;
    }

    @Override
    public boolean isListening(WorldObjectId objectId, IWorldObjectEventListener<?, ?> listener) {
        return this.specificObjectListeners.isListening((Object)objectId, listener);
    }

    @Override
    public boolean isListening(WorldObjectId objectId, Class<?> eventClass, IWorldObjectEventListener<?, ?> listener) {
        if (this.specificObjectEventListeners.containsKey(objectId)) {
            return this.specificObjectEventListeners.get(objectId).isListening(eventClass, listener);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isListening(IWorldEventListener<?> listener) {
        if (this.eventListeners.isListening(listener) || this.specificObjectListeners.isListening(listener)) {
            return true;
        }
        Map<Serializable, ListenersMap<Class>> map = this.objectEventListeners;
        synchronized (map) {
            for (ListenersMap<Class> listeners : this.objectEventListeners.values()) {
                if (!listeners.isListening(listener)) continue;
                return true;
            }
        }
        map = this.specificObjectEventListeners;
        synchronized (map) {
            for (ListenersMap<Class> listeners : this.specificObjectEventListeners.values()) {
                if (!listeners.isListening(listener)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public void removeEventListener(Class<?> eventClass, IWorldEventListener<?> listener) {
        this.eventListeners.remove(eventClass, listener);
    }

    @Override
    public void removeObjectListener(Class<?> objectClass, IWorldObjectEventListener<?, ?> listener) {
        this.objectsListeners.remove(objectClass, listener);
    }

    @Override
    public void removeObjectListener(Class<?> objectClass, Class<?> eventClass, IWorldObjectEventListener<?, ?> listener) {
        if (this.objectEventListeners.containsKey(eventClass)) {
            this.objectEventListeners.get(eventClass).remove(objectClass, listener);
        }
    }

    @Override
    public void removeObjectListener(WorldObjectId objectId, IWorldObjectEventListener<?, ?> listener) {
        this.specificObjectListeners.remove((Object)objectId, listener);
    }

    @Override
    public void removeObjectListener(WorldObjectId objectId, Class<?> eventClass, IWorldObjectEventListener<?, ?> listener) {
        if (this.specificObjectEventListeners.containsKey(objectId)) {
            this.specificObjectEventListeners.get(objectId).remove(eventClass, listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeListener(IWorldEventListener<?> listener) {
        this.eventListeners.remove(listener);
        Map<Class, ListenersMap<Class>> map = this.objectEventListeners;
        synchronized (map) {
            for (ListenersMap<Class> listeners : this.objectEventListeners.values()) {
                listeners.remove(listener);
            }
        }
        this.specificObjectListeners.remove(listener);
        this.specificObjectEventListeners.remove(listener);
    }

    protected synchronized void raiseEvent(IWorldEvent event) {
        if (this.raiseEventProcessing) {
            this.raiseEventsList.add(event);
            return;
        }
        this.raiseEventProcessing = true;
        this.innerRaiseEvent(event);
        while (this.raiseEventsList.size() != 0) {
            this.innerRaiseEvent(this.raiseEventsList.poll());
        }
        this.raiseEventProcessing = false;
    }

    private void notifyLevelAListeners(IWorldEvent event) {
        Collection eventClasses = ClassUtils.getSubclasses(event.getClass());
        this.notifier.setEvent(event);
        for (Class eventClass : eventClasses) {
            this.eventListeners.notify((Object)eventClass, (Listeners.ListenerNotifier)this.notifier);
        }
    }

    private void notifyLevelBListeners(IWorldObjectEvent event) {
        Object object = event.getObject();
        Collection objectClasses = ClassUtils.getSubclasses(object.getClass());
        this.notifier.setEvent(event);
        for (Class objectClass : objectClasses) {
            this.objectsListeners.notify((Object)objectClass, (Listeners.ListenerNotifier)this.notifier);
        }
    }

    private void notifyLevelCListeners(IWorldObjectEvent event) {
        Collection eventClasses = ClassUtils.getSubclasses(event.getClass());
        Collection objectClasses = ClassUtils.getSubclasses(event.getObject().getClass());
        this.notifier.setEvent(event);
        for (Class eventClass : eventClasses) {
            ListenersMap<Class> listeners = this.objectEventListeners.get(eventClass);
            if (listeners == null || !listeners.hasListeners()) continue;
            for (Class objectClass : objectClasses) {
                listeners.notify((Object)objectClass, (Listeners.ListenerNotifier)this.notifier);
            }
        }
    }

    private void notifyLevelDListeners(IWorldObjectEvent event) {
        this.notifier.setEvent(event);
        this.specificObjectListeners.notify((Object)event.getId(), (Listeners.ListenerNotifier)this.notifier);
    }

    private void notifyLevelEListeners(IWorldObjectEvent event) {
        this.notifier.setEvent(event);
        WorldObjectId objectId = event.getId();
        ListenersMap<Class> listeners = this.specificObjectEventListeners.get(objectId);
        if (listeners.hasListeners()) {
            Collection eventClasses = ClassUtils.getSubclasses(event.getClass());
            this.notifier.setEvent(event);
            for (Class eventClass : eventClasses) {
                listeners.notify((Object)eventClass, (Listeners.ListenerNotifier)this.notifier);
            }
        }
    }

    private void innerRaiseEvent(IWorldEvent event) {
        if (this.log.isLoggable(Level.FINEST)) {
            this.log.finest("notifying " + event);
        }
        this.notifyLevelAListeners(event);
        if (event instanceof IWorldObjectEvent) {
            IWorldObjectEvent objectEvent = (IWorldObjectEvent)event;
            this.notifyLevelBListeners(objectEvent);
            this.notifyLevelCListeners(objectEvent);
            this.notifyLevelDListeners(objectEvent);
            this.notifyLevelEListeners(objectEvent);
        }
    }

    private static class ListenerNotifier<T>
    implements Listeners.ListenerNotifier<IListener> {
        private T event = null;

        private ListenerNotifier() {
        }

        public T getEvent() {
            return this.event;
        }

        public void setEvent(T event) {
            this.event = event;
        }

        public void notify(IListener listener) {
            listener.notify(this.event);
        }
    }
}

