/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.multi.communication.worldview.impl;

import cz.cuni.amis.pogamut.base.communication.translator.event.IWorldChangeEvent;
import cz.cuni.amis.pogamut.base.communication.translator.event.IWorldEventWrapper;
import cz.cuni.amis.pogamut.base.communication.translator.event.IWorldObjectUpdateResult;
import cz.cuni.amis.pogamut.base.communication.worldview.event.IWorldEvent;
import cz.cuni.amis.pogamut.base.communication.worldview.object.IWorldObject;
import cz.cuni.amis.pogamut.base.communication.worldview.object.event.WorldObjectDestroyedEvent;
import cz.cuni.amis.pogamut.base.communication.worldview.object.event.WorldObjectFirstEncounteredEvent;
import cz.cuni.amis.pogamut.base.communication.worldview.object.event.WorldObjectUpdatedEvent;
import cz.cuni.amis.pogamut.base.component.bus.exception.ComponentNotRunningException;
import cz.cuni.amis.pogamut.base.component.bus.exception.ComponentPausedException;
import cz.cuni.amis.pogamut.base.component.controller.ComponentState;
import cz.cuni.amis.pogamut.base.utils.guice.AgentTeamScoped;
import cz.cuni.amis.pogamut.multi.agent.ITeamId;
import cz.cuni.amis.pogamut.multi.communication.translator.event.ISharedPropertyUpdateResult;
import cz.cuni.amis.pogamut.multi.communication.translator.event.ISharedPropertyUpdatedEvent;
import cz.cuni.amis.pogamut.multi.communication.translator.event.ISharedWorldObjectUpdatedEvent;
import cz.cuni.amis.pogamut.multi.communication.translator.event.IStaticWorldObjectUpdatedEvent;
import cz.cuni.amis.pogamut.multi.communication.worldview.impl.AbstractSharedWorldView;
import cz.cuni.amis.pogamut.multi.communication.worldview.object.ISharedProperty;
import cz.cuni.amis.pogamut.multi.communication.worldview.object.ISharedWorldObject;
import cz.cuni.amis.pogamut.multi.communication.worldview.object.IStaticWorldObject;
import cz.cuni.amis.pogamut.multi.utils.timekey.TimeKey;
import cz.cuni.amis.utils.NullCheck;
import cz.cuni.amis.utils.exception.PogamutException;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.concurrent.PriorityBlockingQueue;
import java.util.logging.Level;
import java.util.logging.Logger;

@AgentTeamScoped
public abstract class EventDrivenSharedWorldView
extends AbstractSharedWorldView {
    public static final String WORLDVIEW_DEPENDENCY = "EventDrivenSharedWorldViewDependency";
    protected boolean receiveEventProcessing = false;
    protected PriorityBlockingQueue<IWorldChangeEvent> notifyEventsList = new PriorityBlockingQueue<IWorldChangeEvent>(64, new Comparator<IWorldChangeEvent>(){

        @Override
        public int compare(IWorldChangeEvent arg0, IWorldChangeEvent arg1) {
            return (int)Math.signum(arg0.getSimTime() - arg1.getSimTime());
        }
    });
    protected Collection<IWorldChangeEvent> syncEventList = Collections.synchronizedCollection(this.notifyEventsList);

    public EventDrivenSharedWorldView(Logger logger) {
        super(logger);
    }

    private ISharedProperty copyProperty(ISharedProperty original) {
        return original.clone();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void notify(IWorldChangeEvent event) throws ComponentNotRunningException, ComponentPausedException {
        this.log.finest("SharedWorldView notify : [" + event.getSimTime() + " ; " + event);
        if (this.isPaused()) {
            throw new ComponentPausedException((ComponentState)((Object)this.controller.getState().getFlag()), (Object)this);
        }
        if (!this.isRunning()) {
            throw new ComponentNotRunningException((ComponentState)((Object)this.controller.getState().getFlag()), (Object)this);
        }
        Collection<IWorldChangeEvent> collection = this.syncEventList;
        synchronized (collection) {
            this.syncEventList.add(event);
            if (this.receiveEventProcessing) {
                this.log.finest("Added event; events :" + this.notifyEventsList.size());
                return;
            }
            this.receiveEventProcessing = true;
        }
        while (true) {
            IWorldChangeEvent ev = null;
            Collection<IWorldChangeEvent> collection2 = this.syncEventList;
            synchronized (collection2) {
                if (this.notifyEventsList.size() == 0) {
                    this.receiveEventProcessing = false;
                    return;
                }
                ev = this.notifyEventsList.poll();
            }
            if (ev == null) continue;
            boolean exception = false;
            try {
                this.innerNotify(ev);
                continue;
            }
            catch (PogamutException e1) {
                exception = true;
                throw e1;
            }
            catch (Exception e2) {
                exception = true;
                throw new PogamutException("Failed to process: " + ev, (Throwable)e2, (Object)this);
            }
            finally {
                if (!exception) continue;
                this.receiveEventProcessing = false;
                continue;
            }
            break;
        }
    }

    protected void innerNotify(IWorldChangeEvent event) {
        NullCheck.check((Object)event, (String)"event");
        if (this.log.isLoggable(Level.FINEST)) {
            this.log.finest("SharedWorldView processing " + event);
        }
        if (event instanceof ISharedWorldObjectUpdatedEvent) {
            this.sharedObjectUpdatedEvent((ISharedWorldObjectUpdatedEvent)event);
        } else if (event instanceof ISharedPropertyUpdatedEvent) {
            this.propertyUpdatedEvent((ISharedPropertyUpdatedEvent)event);
        } else if (event instanceof IStaticWorldObjectUpdatedEvent) {
            this.staticObjectUpdatedEvent((IStaticWorldObjectUpdatedEvent)event);
        } else if (event instanceof IWorldEventWrapper) {
            this.raiseEvent(((IWorldEventWrapper)event).getWorldEvent());
        } else if (event instanceof IWorldEvent) {
            this.raiseEvent((IWorldEvent)((Object)event));
        } else {
            throw new PogamutException("Unsupported event type received (" + event.getClass() + "): " + event, (Object)this);
        }
    }

    @Override
    protected void raiseEvent(IWorldEvent event) {
        try {
            super.raiseEvent(event);
        }
        catch (Exception e) {
            this.controller.fatalError("Exception raising event " + event, e);
            this.kill();
        }
    }

    protected void sharedObjectUpdatedEvent(ISharedWorldObjectUpdatedEvent updateEvent) {
        boolean created = false;
        boolean updated = false;
        boolean destroyed = false;
        if (!this.syncIdClassMap.containsKey(updateEvent.getId())) {
            this.syncIdClassMap.put(updateEvent.getId(), updateEvent.getCompositeObjectClass());
        }
        block6: for (ISharedPropertyUpdatedEvent propertyEvent : updateEvent.getPropertyEvents()) {
            ISharedProperty property = (ISharedProperty)this.currentSharedProperties.get((Object)updateEvent.getTeamId(), (Object)updateEvent.getId(), (Object)propertyEvent.getPropertyId());
            ISharedProperty copy = null;
            if (property != null) {
                copy = this.copyProperty(property);
            }
            ISharedPropertyUpdateResult updateResult = propertyEvent.update(copy);
            switch (updateResult.getResult()) {
                case CREATED: {
                    created = true;
                    this.propertyCreated(updateResult.getProperty(), updateEvent.getTeamId());
                    continue block6;
                }
                case UPDATED: {
                    if (updateResult.getProperty() != copy) {
                        throw new PogamutException("Update event " + updateEvent + " did not return the same instance of the object (result UPDATED).", (Object)this);
                    }
                    updated = true;
                    this.addOldSharedProperty(property, updateEvent.getTeamId(), propertyEvent.getSimTime());
                    this.propertyUpdated(copy, updateEvent.getTeamId());
                    continue block6;
                }
                case DESTROYED: {
                    this.addOldSharedProperty(property, updateEvent.getTeamId(), propertyEvent.getSimTime());
                    this.removeSharedProperty(property, updateEvent.getTeamId());
                }
                case SAME: {
                    continue block6;
                }
            }
            throw new PogamutException("Unhandled object update result " + (Object)((Object)updateResult.getResult()) + " for the object " + updateEvent.getId() + "." + "Property : " + property, (Object)this);
        }
        if (created) {
            this.objectCreated(this.getShared(updateEvent.getTeamId(), updateEvent.getId(), TimeKey.get(updateEvent.getSimTime())), updateEvent.getSimTime());
        } else if (updated) {
            this.objectUpdated(this.getShared(updateEvent.getTeamId(), updateEvent.getId(), TimeKey.get(updateEvent.getSimTime())), updateEvent.getSimTime());
        } else if (destroyed) {
            this.objectDestroyed(this.getShared(updateEvent.getTeamId(), updateEvent.getId(), TimeKey.get(updateEvent.getSimTime())), updateEvent.getSimTime());
        }
    }

    protected void propertyUpdatedEvent(ISharedPropertyUpdatedEvent event) {
        ISharedProperty property = null;
        ISharedProperty copy = null;
        property = this.getSharedProperty(event.getPropertyId(), event.getTeamId(), TimeKey.get(event.getSimTime()));
        if (property != null) {
            copy = property.clone();
        }
        ISharedPropertyUpdateResult result = event.update(copy);
        switch (result.getResult()) {
            case CREATED: {
                this.propertyCreated(result.getProperty(), event.getTeamId());
                break;
            }
            case UPDATED: {
                this.addOldSharedProperty(property, event.getTeamId(), event.getSimTime());
                this.propertyUpdated(copy, event.getTeamId());
                break;
            }
            case DESTROYED: {
                this.addOldSharedProperty(property, event.getTeamId(), event.getSimTime());
                this.removeSharedProperty(property, event.getTeamId());
                break;
            }
            case SAME: {
                break;
            }
            default: {
                throw new PogamutException("Unexpected update result " + (Object)((Object)result.getResult()) + " for property " + property.toString() + " .", (Object)this);
            }
        }
    }

    protected void staticObjectUpdatedEvent(IStaticWorldObjectUpdatedEvent event) {
        IStaticWorldObject current = super.getStatic(event.getId());
        IWorldObjectUpdateResult<IStaticWorldObject> result = event.update(current);
        switch (result.getResult()) {
            case CREATED: {
                super.addStaticWorldObject(result.getObject());
                break;
            }
            case DESTROYED: {
                super.removeStaticWorldObject(result.getObject());
                break;
            }
            case SAME: {
                return;
            }
            default: {
                throw new PogamutException("Wrong static object update result " + (Object)((Object)result.getResult()) + " for the object " + result.getObject().toString() + " . ", (Object)this);
            }
        }
    }

    protected void propertyCreated(ISharedProperty property, ITeamId team) {
        if (team == null) {
            this.addSharedProperty(property);
            return;
        }
        this.addSharedProperty(property, team);
    }

    protected void propertyUpdated(ISharedProperty property, ITeamId team) {
        this.currentSharedProperties.put((Object)team, (Object)property.getObjectId(), (Object)property.getPropertyId(), (Object)property);
    }

    protected void objectCreated(ISharedWorldObject obj, long time) {
        this.raiseEvent(new WorldObjectFirstEncounteredEvent<ISharedWorldObject>(obj, time));
        this.objectUpdated(obj, time);
    }

    protected void objectUpdated(IWorldObject obj, long time) {
        this.raiseEvent(new WorldObjectUpdatedEvent<IWorldObject>(obj, time));
    }

    protected void objectDestroyed(IWorldObject obj, long time) {
        this.raiseEvent(new WorldObjectDestroyedEvent<IWorldObject>(obj, time));
    }
}

