/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.base.communication.worldview.react;

import cz.cuni.amis.pogamut.base.communication.worldview.IWorldView;
import cz.cuni.amis.pogamut.base.communication.worldview.event.IWorldEvent;
import cz.cuni.amis.pogamut.base.communication.worldview.event.IWorldEventListener;

public abstract class EventReact<EVENT extends IWorldEvent> {
    protected IWorldEventListener<EVENT> reactListener = new IWorldEventListener<EVENT>(){

        public void notify(EVENT event) {
            EventReact.this.preReact(event);
            EventReact.this.react(event);
            EventReact.this.postReact(event);
        }
    };
    protected IWorldView reactWorldView;
    protected Class<EVENT> reactEventClass;
    private boolean reactHooked = false;

    public EventReact(Class<EVENT> eventClass, IWorldView worldView) {
        this.reactWorldView = worldView;
        this.reactEventClass = eventClass;
        this.enable();
    }

    public synchronized void disable() {
        if (this.reactHooked) {
            this.reactHooked = false;
            this.reactWorldView.removeEventListener(this.reactEventClass, this.reactListener);
        }
    }

    public synchronized void enable() {
        if (!this.reactHooked) {
            this.reactHooked = true;
            if (!this.reactWorldView.isListening(this.reactListener)) {
                this.reactWorldView.addEventListener(this.reactEventClass, this.reactListener);
            }
        }
    }

    protected void preReact(EVENT event) {
    }

    protected abstract void react(EVENT var1);

    protected void postReact(EVENT event) {
    }
}

