/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.multi.communication.worldview.impl;

import cz.cuni.amis.pogamut.base.communication.translator.event.IWorldChangeEvent;
import cz.cuni.amis.pogamut.base.communication.translator.event.IWorldObjectUpdateResult;
import cz.cuni.amis.pogamut.base.communication.worldview.object.WorldObjectId;
import cz.cuni.amis.pogamut.base.component.controller.ComponentDependencies;
import cz.cuni.amis.pogamut.base.component.lifecyclebus.ILifecycleBus;
import cz.cuni.amis.pogamut.base.utils.guice.AgentScoped;
import cz.cuni.amis.pogamut.base.utils.logging.IAgentLogger;
import cz.cuni.amis.pogamut.base3d.worldview.object.IViewable;
import cz.cuni.amis.pogamut.multi.agent.ITeamedAgentId;
import cz.cuni.amis.pogamut.multi.communication.translator.event.ICompositeWorldObjectUpdatedEvent;
import cz.cuni.amis.pogamut.multi.communication.translator.event.ILocalWorldObjectUpdatedEvent;
import cz.cuni.amis.pogamut.multi.communication.worldview.ISharedWorldView;
import cz.cuni.amis.pogamut.multi.communication.worldview.IVisionLocalWorldView;
import cz.cuni.amis.pogamut.multi.communication.worldview.impl.AbstractLocalWorldView;
import cz.cuni.amis.pogamut.multi.communication.worldview.impl.EventDrivenLocalWorldView;
import cz.cuni.amis.pogamut.multi.communication.worldview.object.ILocalViewable;
import cz.cuni.amis.pogamut.multi.communication.worldview.object.ILocalWorldObject;
import cz.cuni.amis.utils.ClassUtils;
import cz.cuni.amis.utils.exception.PogamutException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

@AgentScoped
public abstract class VisionLocalWorldView
extends EventDrivenLocalWorldView
implements IVisionLocalWorldView {
    protected AbstractLocalWorldView.LazyCompositeObjectMap<IViewable> visibleMap;
    protected Map<WorldObjectId, IViewable> syncVisibleMap;
    protected Map<Class, Map<WorldObjectId, IViewable>> visibleClassMap;
    protected Map<Class, Map<WorldObjectId, IViewable>> syncVisibleClassMap;

    public VisionLocalWorldView(ComponentDependencies dependencies, ILifecycleBus bus, IAgentLogger logger, ISharedWorldView parentWorldView, ITeamedAgentId agentId) {
        super(dependencies, bus, logger, parentWorldView, agentId);
        this.visibleMap = new AbstractLocalWorldView.LazyCompositeObjectMap(this, this.currentTimeKey);
        this.syncVisibleMap = Collections.synchronizedMap(this.visibleMap);
        this.visibleClassMap = new HashMap<Class, Map<WorldObjectId, IViewable>>();
        this.syncVisibleClassMap = Collections.synchronizedMap(this.visibleClassMap);
    }

    @Override
    public void notify(IWorldChangeEvent event) {
        if (event instanceof ILocalWorldObjectUpdatedEvent) {
            this.objectUpdatedEvent((ILocalWorldObjectUpdatedEvent)event);
        } else if (event instanceof ICompositeWorldObjectUpdatedEvent) {
            this.objectUpdatedEvent(((ICompositeWorldObjectUpdatedEvent)event).getLocalEvent());
        } else {
            super.notify(event);
        }
    }

    @Override
    protected void objectUpdatedEvent(ILocalWorldObjectUpdatedEvent updateEvent) {
        ILocalWorldObject obj = this.getMostRecentLocalWorldObject(updateEvent.getId());
        boolean oldVisible = false;
        boolean isViewable = false;
        ILocalWorldObject copy = null;
        if (obj != null) {
            if (obj instanceof ILocalViewable) {
                oldVisible = ((ILocalViewable)obj).isVisible();
                isViewable = true;
            }
            copy = obj.clone();
        } else {
            copy = null;
        }
        IWorldObjectUpdateResult<ILocalWorldObject> updateResult = updateEvent.update(copy);
        switch (updateResult.getResult()) {
            case CREATED: {
                this.objectCreated(updateResult.getObject());
                return;
            }
            case UPDATED: {
                boolean visible;
                if (updateResult.getObject() != copy) {
                    throw new PogamutException("Update event " + updateEvent + " does not returned the same instance of the object (result UPDATED).", (Object)this);
                }
                super.addOldLocalWorldObject(obj, updateEvent.getSimTime());
                if (isViewable && (visible = ((ILocalViewable)copy).isVisible()) != oldVisible) {
                    if (visible) {
                        this.objectAppeared((ILocalViewable)copy);
                    } else {
                        this.objectDisappeared((ILocalViewable)copy);
                    }
                }
                this.actLocalWorldObjects.put(copy.getId(), copy);
                this.objectUpdated(copy);
                return;
            }
            case SAME: {
                return;
            }
            case DESTROYED: {
                super.addOldLocalWorldObject(obj, updateEvent.getSimTime());
                this.objectDestroyed(copy);
                return;
            }
        }
        throw new PogamutException("Unhandled object update result " + (Object)((Object)updateResult.getResult()) + " for the object " + obj + ".", (Object)this);
    }

    @Override
    public void objectCreated(ILocalWorldObject obj) {
        if (obj instanceof ILocalViewable && ((ILocalViewable)obj).isVisible()) {
            this.objectAppeared((ILocalViewable)obj);
        }
        super.objectCreated(obj);
    }

    @Override
    public void objectDestroyed(ILocalWorldObject obj) {
        if (obj instanceof ILocalViewable) {
            this.removeVisible((ILocalViewable)obj);
        }
        super.objectDestroyed(obj);
    }

    protected void objectAppeared(ILocalViewable obj) {
        this.addVisible(obj);
    }

    protected void objectDisappeared(ILocalViewable obj) {
        this.removeVisible(obj);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void addVisible(ILocalViewable obj) {
        Object object = this.visibleMap;
        synchronized (object) {
            this.visibleMap.addKey(obj.getId());
        }
        object = this.syncVisibleClassMap;
        synchronized (object) {
            for (Class cls : ClassUtils.getSubclasses((Class)obj.getCompositeClass())) {
                AbstractLocalWorldView.LazyCompositeObjectMap map = (AbstractLocalWorldView.LazyCompositeObjectMap)((Object)this.visibleClassMap.get(cls));
                if (map == null) {
                    map = new AbstractLocalWorldView.LazyCompositeObjectMap(this, this.getCurrentTimeKey());
                    this.visibleClassMap.put(cls, (Map<WorldObjectId, IViewable>)((Object)map));
                }
                map.addKey(obj.getId());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void removeVisible(ILocalViewable obj) {
        this.syncVisibleMap.remove(obj.getId());
        Map<Class, Map<WorldObjectId, IViewable>> map = this.visibleClassMap;
        synchronized (map) {
            for (Class cls : ClassUtils.getSubclasses((Class)obj.getCompositeClass())) {
                AbstractLocalWorldView.LazyCompositeObjectMap map2 = (AbstractLocalWorldView.LazyCompositeObjectMap)((Object)this.visibleClassMap.get(cls));
                if (map2 == null) continue;
                map2.remove(obj.getId());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<Class, Map<WorldObjectId, IViewable>> getAllVisible() {
        Map<Class, Map<WorldObjectId, IViewable>> map = this.syncVisibleClassMap;
        synchronized (map) {
            for (Class cls : this.syncVisibleClassMap.keySet()) {
                AbstractLocalWorldView.LazyCompositeObjectMap map2 = (AbstractLocalWorldView.LazyCompositeObjectMap)((Object)this.syncVisibleClassMap.get(cls));
                map2.setTimeKey(this.getCurrentTimeKey());
            }
        }
        return this.visibleClassMap;
    }

    @Override
    public <T extends IViewable> Map<WorldObjectId, T> getAllVisible(Class<T> type) {
        AbstractLocalWorldView.LazyCompositeObjectMap map = (AbstractLocalWorldView.LazyCompositeObjectMap)((Object)this.syncVisibleClassMap.get(type));
        map.setTimeKey(this.getCurrentTimeKey());
        return map;
    }

    @Override
    public Map<WorldObjectId, IViewable> getVisible() {
        AbstractLocalWorldView.LazyCompositeObjectMap map = (AbstractLocalWorldView.LazyCompositeObjectMap)((Object)this.syncVisibleMap);
        map.setTimeKey(this.getCurrentTimeKey());
        return this.syncVisibleMap;
    }

    @Override
    public IViewable getVisible(WorldObjectId id) {
        AbstractLocalWorldView.LazyCompositeObjectMap map = (AbstractLocalWorldView.LazyCompositeObjectMap)((Object)this.syncVisibleMap);
        map.setTimeKey(this.getCurrentTimeKey());
        return (IViewable)this.visibleMap.get(id);
    }
}

