/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.base.component.stub.sharedcomponent;

import cz.cuni.amis.pogamut.base.agent.IAgentId;
import cz.cuni.amis.pogamut.base.component.IComponent;
import cz.cuni.amis.pogamut.base.component.bus.IComponentEvent;
import cz.cuni.amis.utils.Const;
import cz.cuni.amis.utils.NullCheck;
import cz.cuni.amis.utils.SafeEquals;
import java.util.ArrayList;
import java.util.List;
import org.junit.Assert;

public class CheckSharedEvent {
    private List<Class> eventClasses = new ArrayList<Class>();
    private IComponent source = null;
    private IAgentId agentId;

    public CheckSharedEvent(IAgentId agentId, IComponentEvent checkEvent) {
        this.agentId = agentId;
        NullCheck.check((Object)agentId, (String)"agentId");
        for (Class<?> cls : checkEvent.getClass().getInterfaces()) {
            this.eventClasses.add(cls);
        }
        this.source = checkEvent.getSource();
        NullCheck.check((Object)this.source, (String)"checkEvent.getSource()");
    }

    public CheckSharedEvent(IAgentId agentId, Class eventClass) {
        this.agentId = agentId;
        NullCheck.check((Object)agentId, (String)"agentId");
        NullCheck.check((Object)eventClass, (String)"eventClass");
        this.eventClasses.add(eventClass);
    }

    public CheckSharedEvent(IAgentId agentId, Class eventClass, IComponent source) {
        this.agentId = agentId;
        NullCheck.check((Object)agentId, (String)"agentId");
        NullCheck.check((Object)eventClass, (String)"eventClass");
        this.eventClasses.add(eventClass);
        this.source = source;
        NullCheck.check((Object)this.source, (String)"source");
    }

    public CheckSharedEvent(IAgentId agentId, IComponent source) {
        this.agentId = agentId;
        NullCheck.check((Object)agentId, (String)"agentId");
        this.source = source;
        NullCheck.check((Object)this.source, (String)"source");
    }

    public void check(IAgentId agentId, IComponentEvent event) {
        if (!SafeEquals.equals((Object)this.agentId, (Object)agentId)) {
            System.out.println("UNEXPECTED EVENT - WRONG AGENT");
            System.out.println("EXPECTED");
            System.out.println("    FROM AGENT:     " + this.agentId);
            System.out.println("    EVENT:          " + this.eventClasses.get(0).getName());
            if (this.source != null) {
                System.out.println("    FROM COMPONENT: " + this.source);
            }
            System.out.println("GOT");
            System.out.println("    AGENT:          " + agentId);
            System.out.println("    " + event);
            System.out.println("    FROM: " + event.getSource());
            Assert.fail((String)(Const.NEW_LINE + "Event from wrong agent, expected from " + this.agentId + " got from " + agentId + "."));
        }
        for (Class cls : this.eventClasses) {
            if (cls.isAssignableFrom(event.getClass())) continue;
            System.out.println("UNEXPECTED EVENT - WRONG EVENT CLASS");
            System.out.println("EXPECTED");
            System.out.println("    FROM AGENT:     " + this.agentId);
            System.out.println("    EVENT CLASS:    " + cls);
            if (this.source != null) {
                System.out.println("    FROM COMPONENT: " + this.source);
            }
            System.out.println("GOT");
            System.out.println("    AGENT:          " + agentId);
            System.out.println("    EVENT CLASS:    " + event.getClass());
            System.out.println("    FROM COMPONENT: " + event.getSource());
            Assert.fail((String)(Const.NEW_LINE + "Event of wrong class, expected " + cls + " got " + event.getClass() + "."));
        }
        if (this.source != null && this.source != event.getSource()) {
            System.out.println("UNEXPECTED EVENT - WRONG EVENT SOURCE");
            System.out.println("EXPECTED");
            System.out.println("    FROM AGENT:     " + this.agentId);
            System.out.println("    EVENT CLASS:    " + this.eventClasses.get(0).getName());
            if (this.source != null) {
                System.out.println("    FROM COMPONENT: " + this.source);
            }
            System.out.println("GOT");
            System.out.println("    AGENT:          " + agentId);
            System.out.println("    EVENT CLASS:    " + event.getClass());
            System.out.println("    FROM COMPONENT: " + event.getSource());
            Assert.fail((String)(Const.NEW_LINE + "Event from wrong source, expected " + this.source + " got " + event.getSource() + "."));
        }
    }

    public boolean checkNoException(IAgentId agentId, IComponentEvent event) {
        if (!SafeEquals.equals((Object)this.agentId, (Object)agentId)) {
            System.out.println("UNEXPECTED EVENT - WRONG AGENT");
            System.out.println("EXPECTED");
            System.out.println("    FROM AGENT:     " + this.agentId);
            System.out.println("    EVENT:          " + this.eventClasses.get(0).getName());
            if (this.source != null) {
                System.out.println("    FROM COMPONENT: " + this.source);
            }
            System.out.println("GOT");
            System.out.println("    AGENT:          " + agentId);
            System.out.println("    " + event);
            System.out.println("    FROM: " + event.getSource());
            return false;
        }
        for (Class cls : this.eventClasses) {
            if (cls.isAssignableFrom(event.getClass())) continue;
            System.out.println("UNEXPECTED EVENT - WRONG EVENT CLASS");
            System.out.println("EXPECTED");
            System.out.println("    FROM AGENT:     " + this.agentId);
            System.out.println("    EVENT CLASS:    " + cls);
            if (this.source != null) {
                System.out.println("    FROM COMPONENT: " + this.source);
            }
            System.out.println("GOT");
            System.out.println("    AGENT:          " + agentId);
            System.out.println("    EVENT CLASS:    " + event.getClass());
            System.out.println("    FROM COMPONENT: " + event.getSource());
            return false;
        }
        if (this.source != null && this.source != event.getSource()) {
            System.out.println("UNEXPECTED EVENT - WRONG EVENT SOURCE");
            System.out.println("EXPECTED");
            System.out.println("    FROM AGENT:     " + this.agentId);
            System.out.println("    EVENT CLASS:    " + this.eventClasses.get(0).getName());
            if (this.source != null) {
                System.out.println("    FROM COMPONENT: " + this.source);
            }
            System.out.println("GOT");
            System.out.println("    AGENT:          " + agentId);
            System.out.println("    EVENT CLASS:    " + event.getClass());
            System.out.println("    FROM COMPONENT: " + event.getSource());
            return false;
        }
        return true;
    }
}

