/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.base.component.bus;

import cz.cuni.amis.pogamut.base.agent.IAgentId;
import cz.cuni.amis.pogamut.base.agent.impl.AgentId;
import cz.cuni.amis.pogamut.base.component.IComponent;
import cz.cuni.amis.pogamut.base.component.bus.IComponentEvent;
import cz.cuni.amis.pogamut.base.component.bus.IComponentEventListener;
import cz.cuni.amis.pogamut.base.component.bus.event.IStartedEvent;
import cz.cuni.amis.pogamut.base.component.bus.event.impl.StartedEvent;
import cz.cuni.amis.pogamut.base.component.lifecyclebus.ILifecycleBus;
import cz.cuni.amis.pogamut.base.component.lifecyclebus.LifecycleBus;
import cz.cuni.amis.pogamut.base.utils.logging.AgentLogger;
import cz.cuni.amis.pogamut.base.utils.logging.IAgentLogger;
import cz.cuni.amis.tests.BaseTest;
import cz.cuni.amis.utils.StopWatch;
import cz.cuni.amis.utils.maps.LazyMap;
import cz.cuni.amis.utils.sets.ConcurrentLinkedHashSet;
import cz.cuni.amis.utils.token.IToken;
import cz.cuni.amis.utils.token.Tokens;
import java.util.HashSet;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.junit.Assert;
import org.junit.Test;

public class Test12_LifecycleBus
extends BaseTest {
    private static final IToken[] TOKENS = new IToken[]{Tokens.get((String)"token1"), Tokens.get((String)"token2"), Tokens.get((String)"token3")};
    private CountDownLatch latch;
    private IAgentLogger logger;

    @Test
    public void test() {
        AgentId agentId = new AgentId("Test06_LifecycleBus");
        this.logger = new AgentLogger((IAgentId)agentId);
        this.logger.setLevel(Level.OFF);
        LifecycleBus bus = new LifecycleBus(this.logger);
        ConcurrentLinkedHashSet set = new ConcurrentLinkedHashSet();
        Thread[] threads = new Thread[32];
        for (int i = 0; i < threads.length; ++i) {
            threads[i] = new Thread(new BusManager((ILifecycleBus)bus, i + 1));
        }
        this.latch = new CountDownLatch(threads.length);
        StopWatch watch = new StopWatch();
        for (int i = 0; i < threads.length; ++i) {
            threads[i].start();
        }
        try {
            this.latch.await();
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)"Exception waiting for threads...");
        }
        System.out.println("Total time: " + watch.stopStr());
        System.out.println("---/// TEST OK ///---");
    }

    public static void main(String[] args) {
        Test12_LifecycleBus test = new Test12_LifecycleBus();
        test.test();
    }

    private class BusManager
    implements Runnable {
        private Random random = new Random(System.currentTimeMillis());
        private ILifecycleBus bus;
        private int num;
        private int notified = 0;
        private Map<IToken, Set<IComponentEventListener<IStartedEvent>>> listeners = new LazyMap<IToken, Set<IComponentEventListener<IStartedEvent>>>(){

            protected Set<IComponentEventListener<IStartedEvent>> create(IToken key) {
                return new HashSet<IComponentEventListener<IStartedEvent>>();
            }
        };

        private void addListener() {
            IToken token = TOKENS[this.random.nextInt(TOKENS.length)];
            IComponentEventListener<IStartedEvent> listener = new IComponentEventListener<IStartedEvent>(){

                public void notify(IStartedEvent event) {
                    ++BusManager.this.notified;
                }
            };
            this.bus.addEventListener(IStartedEvent.class, (IComponentEventListener)listener);
            this.listeners.get(token).add(listener);
        }

        private void removeListener() {
            IToken token = TOKENS[this.random.nextInt(TOKENS.length)];
            Set<IComponentEventListener<IStartedEvent>> set = this.listeners.get(token);
            if (set.size() > 0) {
                IComponentEventListener<IStartedEvent> listener = set.iterator().next();
                this.bus.removeEventListener(IStartedEvent.class, listener);
                set.remove(listener);
            }
        }

        private void event() {
            final IToken token = TOKENS[this.random.nextInt(TOKENS.length)];
            this.bus.event((IComponentEvent)new StartedEvent(new IComponent(){

                public IToken getComponentId() {
                    return token;
                }

                public Logger getLog() {
                    return Test12_LifecycleBus.this.logger.getCategory(token.getToken());
                }
            }));
        }

        public BusManager(ILifecycleBus bus, int num) {
            this.bus = bus;
            this.num = num;
        }

        @Override
        public void run() {
            StopWatch watch = new StopWatch();
            this.addListener();
            this.event();
            block10: for (int i = 0; i < 1000; ++i) {
                switch (this.random.nextInt(6)) {
                    case 0: {
                        try {
                            Thread.sleep(2L);
                        }
                        catch (InterruptedException interruptedException) {}
                        continue block10;
                    }
                    case 1: {
                        this.addListener();
                        continue block10;
                    }
                    case 2: {
                        this.addListener();
                        continue block10;
                    }
                    case 3: {
                        this.removeListener();
                        continue block10;
                    }
                    case 4: {
                        this.event();
                        continue block10;
                    }
                    case 5: {
                        this.event();
                    }
                }
            }
            System.out.println("Thread " + this.num + ": notified = " + this.notified + ".");
            System.out.println("Thread " + this.num + ": 2000 operations took " + watch.stopStr());
            Test12_LifecycleBus.this.latch.countDown();
            Assert.assertTrue((String)("At least one notification of thread " + this.num + " listener must go through."), (this.notified > 0 ? 1 : 0) != 0);
        }
    }
}

