/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.base.utils;

import cz.cuni.amis.pogamut.base.utils.PogamutPlatform;
import cz.cuni.amis.pogamut.base.utils.PogamutProperty;
import cz.cuni.amis.pogamut.base.utils.jmx.PogamutMBeanServer;
import cz.cuni.amis.pogamut.base.utils.logging.LogCategory;
import cz.cuni.amis.pogamut.base.utils.logging.NetworkLogManager;
import cz.cuni.amis.utils.configuration.PropertiesManager;
import cz.cuni.amis.utils.exception.PogamutException;
import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.rmi.registry.LocateRegistry;
import java.util.Properties;
import java.util.logging.Level;
import javax.management.MBeanServer;
import javax.management.MBeanServerConnection;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXConnectorServer;
import javax.management.remote.JMXConnectorServerFactory;
import javax.management.remote.JMXServiceURL;

public class DefaultPogamutPlatform
implements PogamutPlatform {
    LogCategory log = new LogCategory("DefaultPogamutPlatform");
    static PogamutMBeanServer mBeanServer = null;
    static JMXConnectorServer cs = null;
    JMXServiceURL jmxServiceURL = null;
    PropertiesManager propertiesManager = new PropertiesManager();
    Integer assignedPort = null;
    private boolean registryCreated = false;
    Properties platformProperties = null;
    protected MBeanServerConnection mbsc = null;

    public DefaultPogamutPlatform() {
        this.log.addConsoleHandler();
    }

    @Override
    public JMXServiceURL getMBeanServerURL() throws PogamutException {
        try {
            String hostNameProp = this.getProperty(PogamutProperty.POGAMUT_JMX_SERVER_ADDRESS.getKey());
            String hostName = hostNameProp != null ? hostNameProp : InetAddress.getLocalHost().getHostName();
            return new JMXServiceURL("service:jmx:rmi:///jndi/rmi://" + hostName + ":" + this.getRMIPort() + "/server");
        }
        catch (Exception ex) {
            throw new PogamutException("Error creating the JMX service URL.", (Throwable)ex, (Object)this);
        }
    }

    protected int getRMIPort() throws PogamutException {
        if (this.assignedPort == null) {
            try {
                ServerSocket socket = new ServerSocket(0);
                this.assignedPort = socket.getLocalPort();
                socket.close();
            }
            catch (IOException ex) {
                throw new PogamutException("Error while getting a port for RMI.", (Throwable)ex);
            }
        }
        return this.assignedPort;
    }

    @Override
    public synchronized MBeanServer getMBeanServer() throws PogamutException {
        try {
            if (!this.registryCreated) {
                if (this.log.isLoggable(Level.WARNING)) {
                    this.log.warning("Creating registry at " + this.getRMIPort() + " ...");
                }
                LocateRegistry.createRegistry(this.getRMIPort());
                this.registryCreated = true;
            }
            if (mBeanServer == null) {
                if (this.log.isLoggable(Level.WARNING)) {
                    this.log.warning("Starting MBean server.");
                }
                mBeanServer = new PogamutMBeanServer();
                cs = JMXConnectorServerFactory.newJMXConnectorServer(this.getMBeanServerURL(), null, mBeanServer);
                cs.start();
            }
            return mBeanServer;
        }
        catch (Exception ex) {
            throw new PogamutException("Error during JMX initialization.", (Throwable)ex);
        }
    }

    @Override
    public synchronized void close() throws PogamutException {
        if (this.log.isLoggable(Level.WARNING)) {
            this.log.warning("Closing the platform.");
        }
        try {
            if (cs != null) {
                cs.stop();
            }
            cs = null;
            if (mBeanServer != null) {
                mBeanServer.unregisterAll();
                mBeanServer.clearSaved();
            }
            mBeanServer = null;
        }
        catch (Exception ex) {
            throw new PogamutException("Could not shutdown the mBeanServer!", (Throwable)ex, (Object)this.log);
        }
        finally {
            try {
                NetworkLogManager.getNetworkLogManager().kill();
            }
            catch (Exception ex2) {
                throw new PogamutException("Could not shutdown the log manager!", (Throwable)ex2, (Object)this.log);
            }
        }
    }

    @Override
    public String getProperty(String key, String def) {
        String val = this.getProperty(key);
        return val != null ? val : def;
    }

    @Override
    public String getProperty(String key) {
        return this.propertiesManager.getProperty(key);
    }

    @Override
    public MBeanServerConnection getMBeanServerConnection() throws PogamutException {
        try {
            if (this.mbsc == null) {
                JMXServiceURL url = this.getMBeanServerURL();
                JMXConnector jmxc = JMXConnectorFactory.connect(url, null);
                this.mbsc = jmxc.getMBeanServerConnection();
            }
            return this.mbsc;
        }
        catch (IOException iOException) {
            throw new PogamutException("IO exception occured while creating remote MBeanServer connector.", (Throwable)iOException);
        }
    }

    @Override
    public int getIntProperty(String key) {
        return Integer.parseInt(this.getProperty(key));
    }

    @Override
    public boolean getBooleanProperty(String key) {
        String value = this.getProperty(key);
        if (value == null) {
            return false;
        }
        return value.equalsIgnoreCase("true");
    }
}

