/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.base.agent.utils.runner.impl;

import cz.cuni.amis.pogamut.base.agent.IAgent;
import cz.cuni.amis.pogamut.base.agent.IAgentId;
import cz.cuni.amis.pogamut.base.agent.impl.AgentId;
import cz.cuni.amis.pogamut.base.agent.params.IAgentParameters;
import cz.cuni.amis.pogamut.base.agent.state.level0.IAgentState;
import cz.cuni.amis.pogamut.base.agent.state.level1.IAgentStateDown;
import cz.cuni.amis.pogamut.base.agent.state.level2.IAgentStateFailed;
import cz.cuni.amis.pogamut.base.agent.utils.runner.IAgentDescriptor;
import cz.cuni.amis.pogamut.base.agent.utils.runner.IMultipleAgentRunner;
import cz.cuni.amis.pogamut.base.factory.IAgentFactory;
import cz.cuni.amis.pogamut.base.factory.guice.GuiceAgentModule;
import cz.cuni.amis.pogamut.base.utils.Pogamut;
import cz.cuni.amis.utils.exception.PogamutException;
import cz.cuni.amis.utils.exception.PogamutInterruptedException;
import cz.cuni.amis.utils.flag.FlagListener;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class MultipleAgentRunner<AGENT extends IAgent, PARAMS extends IAgentParameters, MODULE extends GuiceAgentModule>
implements IMultipleAgentRunner<AGENT, PARAMS, MODULE> {
    private static long ID = 0L;
    private static Object idMutex = new Object();
    protected Object mutex = new Object();
    protected Logger log;
    private boolean pausing = false;
    protected Level defaultLogLevel = Level.WARNING;
    protected boolean consoleLogging = true;
    protected CountDownLatch latch;
    protected List<AGENT> agents = null;
    protected boolean killed = false;
    protected boolean main = false;
    protected FlagListener<IAgentState> listener = new FlagListener<IAgentState>(){

        public void flagChanged(IAgentState changedValue) {
            if (changedValue instanceof IAgentStateFailed) {
                MultipleAgentRunner.this.killAgents(MultipleAgentRunner.this.agents);
            } else if (changedValue instanceof IAgentStateDown) {
                MultipleAgentRunner.this.latch.countDown();
            }
        }
    };

    public MultipleAgentRunner<AGENT, PARAMS, MODULE> setLog(Logger log) {
        this.log = log;
        return this;
    }

    public Logger getLog() {
        return this.log;
    }

    public int getAgentCount(IAgentDescriptor<PARAMS, MODULE> ... agentDescriptors) {
        int result = 0;
        for (IAgentDescriptor<PARAMS, MODULE> descriptor : agentDescriptors) {
            result += descriptor.getCount();
        }
        return result;
    }

    protected abstract IAgentParameters newDefaultAgentParameters();

    protected abstract IAgentFactory newAgentFactory(MODULE var1);

    @Override
    public synchronized List<AGENT> startAgents(IAgentDescriptor<PARAMS, MODULE> ... agentDescriptors) {
        if (this.main) {
            return this.startAgentsMain(agentDescriptors);
        }
        return this.startAgentsStandard(agentDescriptors);
    }

    @Override
    public boolean isPausing() {
        return this.pausing;
    }

    @Override
    public synchronized MultipleAgentRunner<AGENT, PARAMS, MODULE> setPausing(boolean state) {
        this.pausing = state;
        return this;
    }

    @Override
    public boolean isMain() {
        return this.main;
    }

    @Override
    public synchronized MultipleAgentRunner<AGENT, PARAMS, MODULE> setMain(boolean state) {
        this.main = state;
        return this;
    }

    public MultipleAgentRunner<AGENT, PARAMS, MODULE> setLogLevel(Level logLevel) {
        this.defaultLogLevel = logLevel;
        return this;
    }

    public MultipleAgentRunner<AGENT, PARAMS, MODULE> setConsoleLogging(boolean enabled) {
        this.consoleLogging = enabled;
        return this;
    }

    protected List<AGENT> startAgentsStandard(IAgentDescriptor<PARAMS, MODULE> ... agentDescriptors) {
        int count = this.getAgentCount(agentDescriptors);
        if (count == 0) {
            return new ArrayList(0);
        }
        ArrayList result = new ArrayList(count);
        try {
            if (this.log != null && this.log.isLoggable(Level.FINE)) {
                this.log.fine("Calling preInitHook()...");
            }
            this.preInitHook();
            for (IAgentDescriptor<PARAMS, MODULE> descriptor : agentDescriptors) {
                this.startAgentsStandard(descriptor, result);
            }
            if (this.isPausing()) {
                if (this.log != null && this.log.isLoggable(Level.FINE)) {
                    this.log.fine("Calling preResumeHook()...");
                }
                this.preResumeHook(result);
                for (IAgent agent : result) {
                    agent.resume();
                }
            }
            if (this.log != null && this.log.isLoggable(Level.FINE)) {
                this.log.fine("Calling postStartedHookCalled()...");
            }
            this.postStartedHook(result);
            return result;
        }
        catch (PogamutException e) {
            this.killAgents(result);
            throw e;
        }
        catch (Exception e) {
            this.killAgents(result);
            throw new PogamutException("Agent's can't be started: " + e.getMessage(), (Throwable)e, (Object)this);
        }
    }

    protected synchronized List<AGENT> startAgentsMain(IAgentDescriptor<PARAMS, MODULE> ... agentDescriptors) {
        int count = this.getAgentCount(agentDescriptors);
        if (count == 0) {
            return new ArrayList(0);
        }
        this.agents = new ArrayList<AGENT>(count);
        this.latch = new CountDownLatch(count);
        this.killed = false;
        boolean pausingBehavior = this.isPausing();
        try {
            if (this.log != null && this.log.isLoggable(Level.FINE)) {
                this.log.fine("Calling preInitHook()...");
            }
            this.preInitHook();
            for (IAgentDescriptor<PARAMS, MODULE> descriptor : agentDescriptors) {
                if (this.killed) break;
                this.startAgentsMain(descriptor, pausingBehavior, this.agents);
            }
            if (pausingBehavior) {
                if (this.log != null && this.log.isLoggable(Level.FINE)) {
                    this.log.fine("Calling preResumeHook()...");
                }
                this.preResumeHook(this.agents);
                for (IAgent agent : this.agents) {
                    if (this.killed) break;
                    agent.resume();
                }
            }
            if (!this.killed) {
                if (this.log != null && this.log.isLoggable(Level.FINE)) {
                    this.log.fine("Calling postStartedHookCalled()...");
                }
                this.postStartedHook(this.agents);
                try {
                    this.latch.await();
                }
                catch (InterruptedException e) {
                    throw new PogamutInterruptedException("Interrupted while waiting for the agents to finish their execution.", (Throwable)e, (Object)this);
                }
            }
            if (this.killed) {
                throw new PogamutException("Could not execute all agents due to an exception, see logs of respective agents.", (Object)this);
            }
            List<AGENT> e = this.agents;
            return e;
        }
        catch (PogamutException e) {
            this.killAgents(this.agents);
            throw e;
        }
        catch (Exception e) {
            this.killAgents(this.agents);
            throw new PogamutException("Agent's can't be started: " + e.getMessage(), (Throwable)e, (Object)this);
        }
        finally {
            Pogamut.getPlatform().close();
        }
    }

    protected void startAgentsStandard(IAgentDescriptor<PARAMS, MODULE> agentDescriptor, List<AGENT> result) {
        if (agentDescriptor == null || agentDescriptor.getCount() == 0) {
            return;
        }
        IAgentFactory agentFactory = this.newAgentFactory(agentDescriptor.getAgentModule());
        IAgentParameters[] agentParams = agentDescriptor.getAgentParameters();
        for (int i = 0; i < agentDescriptor.getCount(); ++i) {
            IAgentParameters params = null;
            if (agentParams.length > i) {
                params = agentParams[i];
                params.assignDefaults(this.newDefaultAgentParameters());
            } else {
                params = this.newDefaultAgentParameters();
            }
            AGENT agent = this.createAgentWithParams(agentFactory, params);
            if (this.log != null && this.log.isLoggable(Level.FINE)) {
                this.log.fine("Calling preStartHook()...");
            }
            this.preStartHook(agent);
            this.startAgent(agent);
            if (this.isPausing()) {
                agent.pause();
            }
            if (this.log != null && this.log.isLoggable(Level.FINE)) {
                this.log.fine("Calling postStartHook()...");
            }
            this.postStartHook(agent);
            result.add(agent);
        }
    }

    protected void startAgentsMain(IAgentDescriptor<PARAMS, MODULE> agentDescriptor, boolean pausingBehavior, List<AGENT> result) {
        if (agentDescriptor == null || agentDescriptor.getCount() == 0) {
            return;
        }
        if (this.killed) {
            return;
        }
        IAgentFactory agentFactory = this.newAgentFactory(agentDescriptor.getAgentModule());
        IAgentParameters[] agentParams = agentDescriptor.getAgentParameters();
        for (int i = 0; i < agentDescriptor.getCount(); ++i) {
            IAgentParameters params = null;
            if (agentParams.length > i) {
                params = agentParams[i];
                params.assignDefaults(this.newDefaultAgentParameters());
            } else {
                params = this.newDefaultAgentParameters();
            }
            if (this.killed) {
                return;
            }
            AGENT agent = this.createAgentWithParams(agentFactory, params);
            result.add(agent);
            if (this.killed) {
                return;
            }
            if (this.log != null && this.log.isLoggable(Level.FINE)) {
                this.log.fine("Calling preStartHook()...");
            }
            this.preStartHook(agent);
            if (this.killed) {
                return;
            }
            this.startAgent(agent);
            if (pausingBehavior) {
                if (this.killed) {
                    return;
                }
                agent.pause();
            }
            if (this.killed) {
                return;
            }
            if (this.log != null && this.log.isLoggable(Level.FINE)) {
                this.log.fine("Calling postStartHook()...");
            }
            this.postStartHook(agent);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected IAgentId newAgentId(String name) {
        if (name == null) {
            name = "Unnamed";
        }
        Object object = idMutex;
        synchronized (object) {
            return new AgentId(name + ++ID);
        }
    }

    protected AGENT createAgentWithParams(IAgentFactory<AGENT, PARAMS> factory, PARAMS params) {
        if (this.log != null && this.log.isLoggable(Level.INFO)) {
            this.log.info("Instantiating agent with id '" + params.getAgentId().getToken() + "'");
        }
        AGENT agent = factory.newAgent(params);
        if (this.consoleLogging) {
            agent.getLogger().addDefaultConsoleHandler();
        }
        if (this.defaultLogLevel != null) {
            agent.getLogger().setLevel(this.defaultLogLevel);
        }
        return agent;
    }

    protected void startAgent(AGENT agent) {
        if (this.log != null && this.log.isLoggable(Level.INFO)) {
            this.log.info("Starting agent with id '" + agent.getComponentId().getToken() + "'");
        }
        if (this.main) {
            agent.getState().addListener(this.listener);
        }
        agent.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void killAgents(List<AGENT> agents) {
        if (agents == null) {
            return;
        }
        Object object = this.mutex;
        synchronized (object) {
            if (this.main) {
                if (this.killed) {
                    return;
                }
                while (this.latch.getCount() > 0L) {
                    this.latch.countDown();
                }
                this.killed = true;
            }
            for (IAgent agent : agents) {
                if (agent == null) continue;
                this.killAgent(agent);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void killAgent(AGENT agent) {
        if (agent == null) {
            return;
        }
        Object object = this.mutex;
        synchronized (object) {
            if (this.main) {
                agent.getState().removeListener(this.listener);
            }
            if (!(agent.getState().getFlag() instanceof IAgentStateDown)) {
                if (this.log != null && this.log.isLoggable(Level.WARNING)) {
                    this.log.warning("Killing agent with id '" + agent.getComponentId().getToken() + "'");
                }
                try {
                    agent.kill();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    protected void preInitHook() throws PogamutException {
    }

    protected void preStartHook(AGENT agent) throws PogamutException {
    }

    protected void postStartHook(AGENT agent) throws PogamutException {
    }

    protected void preResumeHook(List<AGENT> agents) {
    }

    protected void postStartedHook(List<AGENT> agents) {
    }
}

