/*
Gamebots Pogamut derivation Copyright (c) 2010-2011, Michal Bida, Radek Pibil

All rights reserved.

Redistribution and use in source and binary forms, with or without modification, are permitted provided that the following conditions are met:

   * Redistributions of source code must retain the above copyright notice, this list of conditions and the following disclaimer.
   * Redistributions in binary form must reproduce the above copyright notice, this list of conditions and the following disclaimer in the documentation and/or other materials provided with the distribution.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

This software must also be in compliance with the Epic Games Inc. license for mods which states the following: "Your mods must be distributed solely for free, period. Neither you, nor any other person or party, may sell them to anyone, commercially exploit them in any way, or charge anyone for receiving or using them without prior written consent of Epic Games Inc. You may exchange them at no charge among other end-users and distribute them to others over the Internet, on magazine cover disks, or otherwise for free." Please see http://www.epicgames.com/ut2k4_eula.html for more information.

*/
class GBPlayer extends UTPlayerController;

/** Exports key press to all control servers */
reliable server function SendKeyEvent(name InputKey, EInputEvent InputAction) 
{
	local string message;

	if ( PlayerReplicationInfo == none || GBGameInterface(WorldInfo.Game).GetGameHandler() == none )
	{
		return;
	}

    message = "KEYEVENT {PlayerId " $ string(self) $
		"} {PlayerName " $ self.PlayerReplicationInfo.PlayerName $
        "} {Key " $ InputKey $
        "} {Action " $ InputAction $ "}";	

	GBGameInterface(WorldInfo.Game).GetGameHandler().GlobalSendLine(message, true, false);
}

reliable server function ServerRemoteSpectate(){	
	if (self.IsInState('Dead')) {
		GotoState('PlayerWaiting');	
	} else {
		ServerSuicide();
		GotoState('PlayerWaiting');	
	}
}

reliable server function ServerRemoteStopSpectate() {
	//PlayerReplicationInfo.bOnlySpectator = false;
	GotoState('Dead');	
}

unreliable server function ServerSay( string Msg )
{
	local Controller C;

	// center print admin messages which start with #
	if (PlayerReplicationInfo.bAdmin && left(Msg,1) == "#" ) {
		super.ServerSay(Msg);
		return;
	}

	foreach WorldInfo.AllControllers(class'Controller', C) {
		if( C.IsA('RemoteBot') ) {
			RemoteBot(C).RemoteNotifyClientMessage( self, Msg );
		}
	}
	super.ServerSay(Msg);		
}

unreliable server function ServerTeamSay( string Msg )
{
	local Controller C;

	if( !WorldInfo.GRI.GameClass.Default.bTeamGame )
	{
		super.ServerTeamSay( Msg ); //let super method handle this
		return;
	}

	foreach WorldInfo.AllControllers(class'Controller', C) {
		if( C.PlayerReplicationInfo.Team != none ) {
			if (C.PlayerReplicationInfo.Team.TeamIndex == PlayerReplicationInfo.Team.TeamIndex) {
				if( C.isA('RemoteBot') && C != self ) {
					RemoteBot(C).RemoteNotifyTeamMessage(self, Msg);
				}
			}
		}
	}
    super.ServerTeamSay( Msg );
}

reliable server function ServerSuicide()
{
	// remove 10s no-suicide period after spawning

	if ( Pawn != None )
	{
		Pawn.Suicide();
	}
}

auto state PlayerWaiting
{
	simulated event BeginState(Name PreviousStateName)
	{
		local Rotator leveledRotation;
		leveledRotation = Rotation;
		leveledRotation.Roll = 0;
		
		SetRotation(leveledRotation);
		ClientSetRotation(leveledRotation);
		
		super.BeginState( PreviousStateName );
	}
}