/*
Gamebots Pogamut derivation Copyright (c) 2010-2012, Michal Bida
All rights reserved.

Redistribution and use in source and binary forms, with or without modification, are permitted provided that the following conditions are met:

   * Redistributions of source code must retain the above copyright notice, this list of conditions and the following disclaimer.
   * Redistributions in binary form must reproduce the above copyright notice, this list of conditions and the following disclaimer in the documentation and/or other materials provided with the distribution.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

This software must also be in compliance with the Epic Games Inc. license for mods which states the following: "Your mods must be distributed solely for free, period. Neither you, nor any other person or party, may sell them to anyone, commercially exploit them in any way, or charge anyone for receiving or using them without prior written consent of Epic Games Inc. You may exchange them at no charge among other end-users and distribute them to others over the Internet, on magazine cover disks, or otherwise for free." Please see http://www.epicgames.com/ut2k4_eula.html for more information.

*/
/** Custom GM scenario Pawn that handles custom animation playing. */
class GBScenarioPawn extends GBPawn;

/** 
 *  Here we set appropriate node in Animation Tree that will be used to play custom animations, should be set 
 *  in simulated PostBeginPlay() of all child Pawns
 */
var AnimNodePlayCustomAnim myCustomAnim;

/** Name of the next animation that should be played */
var	name	PlayAnimName;
/** Whether the next animation should be played in loop */
var bool    PlayAnimLooping;
/** Name of the last custom animation played */
var	name	LastPlayAnimName;
/** Status of last played animation looping */
var bool    LastPlayAnimLooping;

/** 
 *  This is a hack, we need this so we can notify client it should play PlayAnimName animation.  
 *  Changes of this variable are notified on clients in ReplicateEvent function.
 */
var	repnotify	int   IntAnim;

replication
{
	if (Role == ROLE_Authority)
		PlayAnimName, PlayAnimLooping, IntAnim;
}

/** Is called when some repnotify variable was replicated with new value from server to client */
simulated event ReplicatedEvent(name VarName)
{
	if ( VarName == 'IntAnim' ) {
		//`log("GBPawn:IntAnimWay!:IntAnim:" $ IntAnim);		
		RemotePlayCustomAnim(PlayAnimName, PlayAnimLooping);		
	} else {
		super.ReplicatedEvent(VarName);
	}
}

/** Function called and executed on the server - sets stuff on server + sets replicated vars on client */
function SetNextPlayAnim(name newAnim, bool bLooping) {
	//set stuff on client
	PlayAnimName = newAnim;
	PlayAnimLooping = bLooping;
	IntAnim += 1;
	//do stuff on server	
	RemotePlayCustomAnim(newAnim, bLooping);	
}



/** Responsible for playing custom animations */
simulated function RemotePlayCustomAnim(name animName, bool bLooping) {
	//`log("GBPawn:RemotePlayCustomAnim:animName:" $ animName $ ";bLooping:" $ bLooping $ ";CustomAnim:" $ myCustomAnim);
	if (myCustomAnim == none) //if we dont have custom anim node, then we won't play anything
		return;

	if (animName == 'idleanim' && myCustomAnim.bIsPlayingCustomAnim){
		//idle animation means - stop current custom animation and continue to default animation tree...
		myCustomAnim.StopCustomAnim(0.25);		
		// we also reset last played anims
		LastPlayAnimName = '';	
		LastPlayAnimLooping = false;						
		return;
	} else if (animName == 'idleanim') {
		//idle anim sent, but we are not playing anything, so we do nothing.
		return;
	}

	//TODO: Implement check whether the animation exists in our AnimationSets with NPCMesh.FindAnimSequence - but wouldn't it be slow for 500+ anims?
	if (myCustomAnim.bIsPlayingCustomAnim) {
		if (animName != LastPlayAnimName) {
			myCustomAnim.SetCustomAnim(PlayAnimName);			
			myCustomAnim.PlayCustomAnim(animName,1,0.4,0.2,bLooping,true);
		} else {
			if (LastPlayAnimLooping && !bLooping) {
				myCustomAnim.PlayCustomAnim(animName,1,0.4,0.2,bLooping,true);
			}		
		}		
	} else {
		myCustomAnim.SetCustomAnim(PlayAnimName);
		myCustomAnim.PlayCustomAnim(animName,1,0.4,0.2,bLooping,true);
	}
	
	LastPlayAnimName = animName;	
	LastPlayAnimLooping = bLooping;						
}
		
/** Doesnt seem that it is called */
function OnPlayAnim( UTSeqAct_PlayAnim InAction )
{
	//`log("NPCTestPawn:OnPlayAnim:" $ InAction.AnimName);
}
/** Doesnt seem that it is called */
simulated event OnAnimEnd(AnimNodeSequence SeqNode, float PlayedTime, float ExcessTime)
{ 
	//`log("NPCTestPawn:OnAnimEnd:" $ SeqNode.AnimSeqName $ ";PlayingDefaultAnim:" $ DefaultIdleAnimation);
}
DefaultProperties
{

}
