/*
Gamebots Pogamut derivation Copyright (c) 2010-2011, Michal Bida, Radek Pibil

All rights reserved.

Redistribution and use in source and binary forms, with or without modification, are permitted provided that the following conditions are met:

   * Redistributions of source code must retain the above copyright notice, this list of conditions and the following disclaimer.
   * Redistributions in binary form must reproduce the above copyright notice, this list of conditions and the following disclaimer in the documentation and/or other materials provided with the distribution.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

This software must also be in compliance with the Epic Games Inc. license for mods which states the following: "Your mods must be distributed solely for free, period. Neither you, nor any other person or party, may sell them to anyone, commercially exploit them in any way, or charge anyone for receiving or using them without prior written consent of Epic Games Inc. You may exchange them at no charge among other end-users and distribute them to others over the Internet, on magazine cover disks, or otherwise for free." Please see http://www.epicgames.com/ut2k4_eula.html for more information.

*/
/** Custom GM scenario Pawn that handles custom animation playing. */
class GBScenarioPawn extends GBPawn;

/** Slot playing animations on whole body */
var AnimNodeSlot myFullBodySlot;
/** Slot playing animations on upper part of body only - currently does not work! */
var AnimNodeSlot myTopHalfSlot;
/** Sequence node attached to myFullBodySlot - can be used for playing custom anims as well */
var AnimNodeSequence myFullBodySlotSequence;

/** Name of the next animation that should be played */
var	name	PlayAnimName;
/** Name of the animation that should be played after PlayAnimName animation is finished */
var	name	NextPlayAnimName;
/** Whether we should loop PlayAnimName animation */
var bool    PlayAnimLooping;
/** Whether we should loop NextPlayAnimName animation */
var bool    NextPlayAnimLooping;

/** Name of the last played animation */
var	name	LastPlayAnimName;
/** Status of last played animation looping */
var bool    LastPlayAnimLooping;

/** Default idle animation that will be played for this pawn */
var name DefaultIdleAnimation;

/** 
 *  This is a hack, we need this so we can notify client it should play PlayAnimName animation.  
 *  Changes of this variable are notified on clients in ReplicateEvent function.
 */
var	repnotify	int   IntAnim;

replication
{
	if (Role == ROLE_Authority)
		PlayAnimName, NextPlayAnimName, PlayAnimLooping, NextPlayAnimLooping, IntAnim;
}

/** Is called when some repnotify variable was replicated with new value from server to client */
simulated event ReplicatedEvent(name VarName)
{
	if ( VarName == 'IntAnim' )
	{
		`log("GBPawn:IntAnimWay!:IntAnim:" $ IntAnim);
		//RemotePlayCustomAnim(AnimNames[IntAnim], false);		
		RemotePlayCustomAnim(PlayAnimName, PlayAnimLooping);		
	}
	else
	{
		super.ReplicatedEvent(VarName);
	}
}

/** Responsible for playing custom animations */
simulated function RemotePlayCustomAnim(name animName, bool bLooping) {
	`log("GBPawn:RemotePlayCustomAnim:animName:" $ animName $ ";bLooping:" $ bLooping $ ";FullBodySlot:" $ myFullBodySlot);
	if (myFullBodySlot != none) {
		if (animName == LastPlayAnimName && LastPlayAnimLooping) {
			//we are already playing requested animation in a loop, we will do nothing unless looping was canceled:
			if (!bLooping) {
				if (animName == 'idleanim') {//code for default idle animation
					myFullBodySlot.PlayCustomAnim(DefaultIdleAnimation,1,0.3,0.2,bLooping,true);
				} else {
					myFullBodySlot.PlayCustomAnim(animName,1,0.3,0.2,bLooping,true);
				}
				LastPlayAnimLooping = bLooping;
			}
		} else {
			if (animName == 'idleanim') {//code for default idle animation
				myFullBodySlot.PlayCustomAnim(DefaultIdleAnimation,1,0.3,0.2,bLooping,true);
			} else {
				myFullBodySlot.PlayCustomAnim(animName,1,0.3,0.2,bLooping,true);
			}
			LastPlayAnimName = animName;
			LastPlayAnimLooping = bLooping;			
		}
	}
}

function OnPlayAnim( UTSeqAct_PlayAnim InAction )
{
	`log("NPCTestPawn:OnPlayAnim:" $ InAction.AnimName);
	/*if( FullBodyAnimSlot != None )
	{
		FullBodyAnimSlot.PlayCustomAnim(InAction.AnimName, 1.0, 0.2, 0.2, InAction.bLooping, true);
	}*/
	
}

simulated event OnAnimEnd(AnimNodeSequence SeqNode, float PlayedTime, float ExcessTime)
{ 
	if (NextPlayAnimName == '') {
		`log("NPCTestPawn:OnAnimEnd:" $ SeqNode.AnimSeqName $ ";PlayingDefaultAnim:" $ DefaultIdleAnimation);
		myFullBodySlot.PlayCustomAnim(DefaultIdleAnimation,1,0.3,0.2,true,true);
		LastPlayAnimName = DefaultIdleAnimation;
		LastPlayAnimLooping = true;		
	} else {
		`log("NPCTestPawn:OnAnimEnd:" $ SeqNode.AnimSeqName $ ";PlayingNextAnim:" $ NextPlayAnimName);
		myFullBodySlot.PlayCustomAnim(NextPlayAnimName,1,0.3,0.2,NextPlayAnimLooping,true);
		LastPlayAnimName = NextPlayAnimName;
		LastPlayAnimLooping = NextPlayAnimLooping;	
	}
	//if (SeqNode.AnimSeqName == 'walk_slow_01')
	//	myCustomFullBody.PlayCustomAnim('walk_slow_01',1,1,,false,true);
	//else
	//	myCustomTopHalf.PlayCustomAnim('standing_idle_lookaround_01',1,1,,false,true);
	   //myCustomAnimNode.PlayCustomAnim('standing_idle_lookaround_01',1,1,,false,);
		
   
	//myFullBodySlotSequence.SetAnim('standing_idle_lookaround_01');
	//myFullBodySlotSequence.PlayAnim(false,1,);
	//myFullBodySlotSequence.bPlaying = true;
	//SeqNode.SetAnim('standing_idle_lookaround_01');
	//SeqNode.PlayAnim(false,1,);		
}

DefaultProperties
{
	DefaultIdleAnimation="standing_idle_breathe_02"
}
