/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.sposh.context;

import cz.cuni.amis.pogamut.base.agent.navigation.IPathPlanner;
import cz.cuni.amis.pogamut.base.agent.navigation.IStuckDetector;
import cz.cuni.amis.pogamut.base.communication.command.IAct;
import cz.cuni.amis.pogamut.base.communication.worldview.IWorldView;
import cz.cuni.amis.pogamut.base.communication.worldview.listener.annotation.AnnotationListenerRegistrator;
import cz.cuni.amis.pogamut.base.utils.logging.LogCategory;
import cz.cuni.amis.pogamut.base3d.worldview.IVisionWorldView;
import cz.cuni.amis.pogamut.base3d.worldview.object.ILocated;
import cz.cuni.amis.pogamut.emohawk.agent.module.sensomotoric.Animations;
import cz.cuni.amis.pogamut.emohawk.agent.module.sensomotoric.Emoticons;
import cz.cuni.amis.pogamut.emohawk.agent.module.sensomotoric.Inventory;
import cz.cuni.amis.pogamut.emohawk.agent.module.sensomotoric.Places;
import cz.cuni.amis.pogamut.emohawk.agent.module.sensomotoric.Steering;
import cz.cuni.amis.pogamut.sposh.JavaBehaviour;
import cz.cuni.amis.pogamut.ut2004.agent.module.sensomotoric.AgentConfig;
import cz.cuni.amis.pogamut.ut2004.agent.module.sensomotoric.Raycasting;
import cz.cuni.amis.pogamut.ut2004.agent.module.sensor.AgentInfo;
import cz.cuni.amis.pogamut.ut2004.agent.module.sensor.AgentStats;
import cz.cuni.amis.pogamut.ut2004.agent.module.sensor.Game;
import cz.cuni.amis.pogamut.ut2004.agent.module.sensor.Players;
import cz.cuni.amis.pogamut.ut2004.agent.module.sensor.Senses;
import cz.cuni.amis.pogamut.ut2004.agent.navigation.IUT2004GetBackToNavGraph;
import cz.cuni.amis.pogamut.ut2004.agent.navigation.IUT2004PathNavigator;
import cz.cuni.amis.pogamut.ut2004.agent.navigation.IUT2004RunStraight;
import cz.cuni.amis.pogamut.ut2004.agent.navigation.UT2004AStarPathPlanner;
import cz.cuni.amis.pogamut.ut2004.agent.navigation.UT2004GetBackToNavGraph;
import cz.cuni.amis.pogamut.ut2004.agent.navigation.UT2004Navigation;
import cz.cuni.amis.pogamut.ut2004.agent.navigation.UT2004PathExecutor;
import cz.cuni.amis.pogamut.ut2004.agent.navigation.UT2004RunStraight;
import cz.cuni.amis.pogamut.ut2004.agent.navigation.floydwarshall.FloydWarshallMap;
import cz.cuni.amis.pogamut.ut2004.agent.navigation.loquenavigator.LoqueNavigator;
import cz.cuni.amis.pogamut.ut2004.agent.navigation.stuckdetector.UT2004DistanceStuckDetector;
import cz.cuni.amis.pogamut.ut2004.agent.navigation.stuckdetector.UT2004PositionStuckDetector;
import cz.cuni.amis.pogamut.ut2004.agent.navigation.stuckdetector.UT2004TimeStuckDetector;
import cz.cuni.amis.pogamut.ut2004.bot.command.AdvancedLocomotion;
import cz.cuni.amis.pogamut.ut2004.bot.command.Communication;
import cz.cuni.amis.pogamut.ut2004.bot.impl.UT2004Bot;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.ConfigChange;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.GameInfo;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.InitedMessage;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.Self;
import java.util.Random;
import java.util.logging.Level;
import java.util.logging.Logger;

public class EmohawkBehaviour<BOT extends UT2004Bot>
extends JavaBehaviour<BOT> {
    protected LogCategory log;
    protected Random random = new Random(System.currentTimeMillis());
    protected Game game;
    protected AgentInfo info;
    protected Players players;
    protected Senses senses;
    protected AgentConfig config;
    protected Raycasting raycasting;
    protected AdvancedLocomotion move;
    protected Communication comm;
    protected UT2004PathExecutor<ILocated> pathExecutor = null;
    protected IPathPlanner<ILocated> pathPlanner = null;
    protected UT2004GetBackToNavGraph getBackToNavGraph;
    protected UT2004RunStraight runStraight;
    protected UT2004Navigation navigation;
    protected AnnotationListenerRegistrator listenerRegistrator;
    protected IVisionWorldView world;
    protected IAct act;
    protected AgentStats stats;
    protected FloydWarshallMap fwMap;
    protected Animations animations;
    protected Emoticons emoticons;
    protected Places places;
    protected Steering steering;
    protected Inventory inventory;

    public EmohawkBehaviour(String name, BOT bot) {
        super(name, bot);
        this.log = bot.getLogger().getCategory("User");
        this.log.setLevel(Level.ALL);
    }

    protected void prepareBehaviour(BOT bot) {
    }

    public void botInitialized(GameInfo info, ConfigChange config, InitedMessage init) {
    }

    public void botFirstSpawned(GameInfo gameInfo, ConfigChange config, InitedMessage init, Self self) {
    }

    public void initializeBehaviour(BOT bot) {
        this.world = this.getWorldView();
        this.act = this.getAct();
        this.initializeModules(bot);
        this.initializePathFinding(bot);
        this.initializeListeners(bot);
    }

    protected void initializeListeners(BOT bot) {
        this.listenerRegistrator = new AnnotationListenerRegistrator((Object)this, (IWorldView)this.getWorldView(), (Logger)bot.getLogger().getCategory("Listeners"));
        this.listenerRegistrator.addListeners();
    }

    protected void initializePathFinding(BOT bot) {
        this.pathPlanner = new UT2004AStarPathPlanner(bot);
        this.fwMap = new FloydWarshallMap(bot);
        this.pathExecutor = new UT2004PathExecutor(bot, (IUT2004PathNavigator)new LoqueNavigator(bot, (Logger)bot.getLog()));
        this.pathExecutor.addStuckDetector((IStuckDetector)new UT2004TimeStuckDetector(bot, 3000.0, 100000.0));
        this.pathExecutor.addStuckDetector((IStuckDetector)new UT2004PositionStuckDetector(bot));
        this.pathExecutor.addStuckDetector((IStuckDetector)new UT2004DistanceStuckDetector(bot));
        this.getBackToNavGraph = new UT2004GetBackToNavGraph(bot, this.info, this.move);
        this.runStraight = new UT2004RunStraight(bot, this.info, this.move);
        this.navigation = new UT2004Navigation(bot, this.pathExecutor, (IPathPlanner)this.fwMap, (IUT2004GetBackToNavGraph)this.getBackToNavGraph, (IUT2004RunStraight)this.runStraight);
    }

    protected void initializeModules(BOT bot) {
        this.game = new Game(bot);
        this.info = new AgentInfo(bot, this.game);
        this.players = new Players(bot);
        this.senses = new Senses(bot, this.info, this.players);
        this.config = new AgentConfig(bot);
        this.raycasting = new Raycasting(bot);
        this.move = new AdvancedLocomotion((UT2004Bot)this.getBot(), (Logger)((UT2004Bot)this.getBot()).getLogger().getCategory("Move"));
        this.comm = new Communication((UT2004Bot)this.getBot(), (Logger)((UT2004Bot)this.getBot()).getLogger().getCategory("Communicaton"));
        this.stats = new AgentStats(bot);
        this.animations = new Animations(bot);
        this.emoticons = new Emoticons(bot);
        this.places = new Places(bot);
        this.steering = new Steering(bot);
        this.inventory = new Inventory(bot);
    }

    public void finishBehaviourInitialization() {
    }

    public IAct getAct() {
        return this.act;
    }

    public IVisionWorldView getWorldView() {
        return ((UT2004Bot)this.getBot()).getWorldView();
    }

    public LogCategory getLog() {
        return this.log;
    }

    public Random getRandom() {
        return this.random;
    }

    public Game getGame() {
        return this.game;
    }

    public AgentInfo getInfo() {
        return this.info;
    }

    public Players getPlayers() {
        return this.players;
    }

    public Senses getBotSenses() {
        return this.senses;
    }

    public AgentConfig getConfig() {
        return this.config;
    }

    public Raycasting getRaycasting() {
        return this.raycasting;
    }

    public AdvancedLocomotion getMove() {
        return this.move;
    }

    public Communication getComm() {
        return this.comm;
    }

    public UT2004PathExecutor<ILocated> getPathExecutor() {
        return this.pathExecutor;
    }

    public IPathPlanner<ILocated> getPathPlanner() {
        return this.pathPlanner;
    }

    public UT2004GetBackToNavGraph getGetBackToNavGraph() {
        return this.getBackToNavGraph;
    }

    public UT2004RunStraight getRunStraight() {
        return this.runStraight;
    }

    public UT2004Navigation getNavigation() {
        return this.navigation;
    }

    public AnnotationListenerRegistrator getListenerRegistrator() {
        return this.listenerRegistrator;
    }

    public IVisionWorldView getWorld() {
        return this.world;
    }

    public AgentStats getStats() {
        return this.stats;
    }

    public FloydWarshallMap getFwMap() {
        return this.fwMap;
    }

    public Animations getAnimations() {
        return this.animations;
    }

    public Emoticons getEmoticons() {
        return this.emoticons;
    }

    public Places getPlaces() {
        return this.places;
    }

    public Steering getSteering() {
        return this.steering;
    }

    public Inventory getInventory() {
        return this.inventory;
    }
}

