package cz.cuni.amis.pogamut.emohawk.examples.modularsposhmoodbot;

import cz.cuni.amis.pogamut.sposh.context.EmohawkContext;
import cz.cuni.amis.pogamut.sposh.engine.VariableContext;
import cz.cuni.amis.pogamut.sposh.executor.PrimitiveInfo;
import cz.cuni.amis.pogamut.sposh.executor.StateSense;
import cz.cuni.amis.utils.Cooldown;

/**
 * Sense for checking the mood.
 * 
 * @author Jimmy
 */
@PrimitiveInfo(name = "moodChanged", description = "Whether the bot's mood has changed.")
public class MoodChanged extends StateSense<EmohawkContext, Boolean> {

	private Cooldown moodChanged = new Cooldown(7500);
	
    public MoodChanged(EmohawkContext ctx) {
        super("moodChanged", ctx);
    }

    @Override
    public Boolean query(VariableContext params) {
    	ctx.getLog().info("moodChanged() == " + moodChanged.isCool());
        return moodChanged.tryUse();
    }
}
