package cz.cuni.amis.pogamut.emohawk.examples.modularsposhmoodbot;

import cz.cuni.amis.pogamut.emohawk.agent.module.sensomotoric.EmoticonBubbleType;
import cz.cuni.amis.pogamut.emohawk.agent.module.sensomotoric.EmoticonType;
import cz.cuni.amis.pogamut.sposh.context.EmohawkContext;
import cz.cuni.amis.pogamut.sposh.engine.VariableContext;
import cz.cuni.amis.pogamut.sposh.executor.ActionResult;
import cz.cuni.amis.pogamut.sposh.executor.PrimitiveInfo;
import cz.cuni.amis.pogamut.sposh.executor.StateAction;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.NavPoint;
import cz.cuni.amis.utils.collections.MyCollections;

/**
 * Action that causes bot to randommly change the thought emoticon.
 * 
 * @author Jimmy
 */
@PrimitiveInfo(name = "changeMood", description = "Randomly switch the thought emoticon.")
public class ChangeMood extends StateAction<EmohawkContext> {

    public ChangeMood(EmohawkContext ctx) {
        super("changeMood", ctx);
    }

    @Override
    public void init(VariableContext params) {
    }

    @Override
    public ActionResult run(VariableContext params) {
    	// it is adviced to always log your actions in order for you to get a grasp on how SPOSH is evaluating the plan
    	ctx.getLog().info("changeMood()");
    	EmoticonType newMood = MyCollections.getRandom(EmoticonType.values());
    	ctx.getEmoticons().setEmoticons(4, EmoticonBubbleType.BUBBLE_THOUGHT_CENTER, newMood);    	
    	               
        return ActionResult.FINISHED;
    }

    @Override
    public void done(VariableContext params) {
    }
}
