package cz.cuni.amis.pogamut.emohawk.examples.modularsposhmoodbot;

import java.io.IOException;
import java.util.logging.Level;

import cz.cuni.amis.pogamut.sposh.ut2004.StateSposhLogicController;
import cz.cuni.amis.pogamut.ut2004.bot.impl.UT2004Bot;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbcommands.Initialize;
import cz.cuni.amis.pogamut.ut2004.utils.UT2004BotRunner;
import cz.cuni.amis.utils.exception.PogamutException;

/**
 * Create simple bot that is running around the map and expresses random thoughts.
 * 
 * @author Jimmy
 */
public class MoodLogic extends StateSposhLogicController<UT2004Bot, MoodContext> {
	
    private String SPOSH_PLAN_RESOURCE = "sposh/plan/BotPlan.lap";

    @Override
    protected String getPlan() throws IOException {
        return getPlanFromResource(SPOSH_PLAN_RESOURCE);
    }

    /**
     * Create context that can be accessed in every state primitive.
     * @return new context of this bot.
     */
    @Override
    protected MoodContext createContext() {
        return new MoodContext(bot);
    }

    /**
     * Initialize command of the bot, called during initial handshake, init can
     * set things like name of bot, its skin, skill, team ect.
     * @see Initialize
     * @return
     */
    @Override
    public Initialize getInitializeCommand() {
        return new Initialize().setName("SPOSH-Modular-MoodBot");
    }

    /**
     * Create an {@link ExternalBot} with custom made logic and
     * try to connect to Unreal Server at localhost:3000
     *
     * @param args the command line arguments
     */
    public static void main(String[] args) throws PogamutException {
        new UT2004BotRunner(MoodLogic.class, "SPOSH-Modular-MoodBot").setMain(true).setLogLevel(Level.INFO).startAgent();
    }
}
