package cz.cuni.amis.pogamut.emohawk.examples.modularsposhmoodbot;

import cz.cuni.amis.pogamut.sposh.context.EmohawkContext;
import cz.cuni.amis.pogamut.sposh.engine.VariableContext;
import cz.cuni.amis.pogamut.sposh.executor.ActionResult;
import cz.cuni.amis.pogamut.sposh.executor.PrimitiveInfo;
import cz.cuni.amis.pogamut.sposh.executor.StateAction;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.NavPoint;
import cz.cuni.amis.utils.collections.MyCollections;

/**
 * Action that causes bot to run around the map randomly.
 * 
 * @author Jimmy
 */
@PrimitiveInfo(name = "runAroundMap", description = "Run around the map.")
public class RunAroundMap extends StateAction<EmohawkContext> {

    public RunAroundMap(EmohawkContext ctx) {
        super("runAroundMap", ctx);
    }

    @Override
    public void init(VariableContext params) {
    }

    @Override
    public ActionResult run(VariableContext params) {
        //if (true) return true;
    	if (ctx.getNavigation().isNavigating()) {
    		ctx.getLog().info("Navigating...");
        } else {
            NavPoint nav = MyCollections.getRandom(ctx.getWorldView().getAll(NavPoint.class).values());
            ctx.getNavigation().navigate(nav);
            ctx.getLog().warning("GOING FOR NAV: " + nav);
        }
                       
        return ActionResult.FINISHED;
    }

    @Override
    public void done(VariableContext params) {
        ctx.getNavigation().stopNavigation();
    }
}
