package cz.cuni.amis.pogamut.emohawk.examples.twobots;

import SteeringProperties.ObstacleAvoidanceProperties;
import SteeringProperties.PathFollowingProperties;
import SteeringProperties.TargetApproachingProperties;
import cz.cuni.amis.pogamut.base.communication.worldview.event.IWorldEventListener;
import cz.cuni.amis.pogamut.base.utils.guice.AgentScoped;
import cz.cuni.amis.pogamut.base3d.worldview.object.Location;
import cz.cuni.amis.pogamut.emohawk.agent.module.sensomotoric.AnimType;
import cz.cuni.amis.pogamut.emohawk.agent.module.sensomotoric.CharacterType;
import cz.cuni.amis.pogamut.emohawk.agent.module.sensomotoric.EmoticonBubbleType;
import cz.cuni.amis.pogamut.emohawk.agent.module.sensomotoric.EmoticonInfo;
import cz.cuni.amis.pogamut.emohawk.agent.module.sensomotoric.EmoticonType;
import cz.cuni.amis.pogamut.emohawk.bot.impl.EmohawkBotController;
import cz.cuni.amis.pogamut.unreal.communication.messages.UnrealId;
import cz.cuni.amis.pogamut.ut2004.agent.module.utils.TabooSet;
import cz.cuni.amis.pogamut.ut2004.bot.impl.UT2004Bot;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbcommands.Initialize;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbcommands.SendMessage;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbcommands.Stop;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbcommands.TurnTo;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.BotKilled;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.ConfigChange;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.GameInfo;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.GlobalChat;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.InitedMessage;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.NavPoint;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.Player;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.Self;
import cz.cuni.amis.pogamut.ut2004.utils.UT2004BotRunner;
import cz.cuni.amis.utils.Heatup;
import cz.cuni.amis.utils.exception.PogamutException;
import java.util.Collection;
import java.util.HashSet;
import java.util.Random;

/**
 * PogamutEmohawk's two bots example showing few extra things such as emoticons handling
 * and characters synchronization. 
 * <p><p>
 *
 * @author Michal Bida aka Knight
 * @author Rudolf Kadlec aka ik
 * @author Jakub Gemrot aka Jimmy
 */
@AgentScoped
public class EmohawkTwoBotsReacting extends EmohawkBotController {

    /** heatup that we use to introduce delay between two consequent emoticons - 6 seconds*/
    Heatup dialogPause = new Heatup(6000);
    /** Whether we are currently in a dialog */
    boolean bDialogInProgress = false;
    /** Time when our last dialog was started in seconds */
    double dialogStartTime = 0;
    /** how often we react to bump event */
    Heatup bumpResponsePause = new Heatup(6000);
    /** hash set with greeted players */
    HashSet<UnrealId> greetedPlayers = new HashSet();
    /** current target we are heading to */
    Player currentPlayerTarget = null;
    /** Time when we last responed to current player emoticon */
    long lastCurPlayerEmoticonResponseTime = 0;
    /** Emoticon of other player wa want to react to */
    EmoticonInfo emoticonToReact = null;
    /** here we store previous emoticon we reacted to */
    EmoticonInfo previousEmoticonToReact = null;
    /** nav point we are heading to */
    NavPoint currentNavTarget = null;
    /** If we are closer than this to target destination, we will take it as we are already there */
    private static final int AT_LOC_THRESHOLD = 300;
    /** taboo set for players */
    TabooSet<Player> tabooPlayers;
    /** How long in seconds do we want to engage in a dialog */
    private static final int DIALOG_TIMEOUT = 30;
    /**
     * After finished dialog, we will wait 30 secs before we engage in another dialog with
     * the same player
     */
    private static final int NO_DIALOG_TIMEOUT = 30 + EmohawkTwoBotsReacting.DIALOG_TIMEOUT;
    /** Random reaction pause */
    int randomReactionPause = 2000 + new Random(System.currentTimeMillis()).nextInt(2000);
    /**
     * Chat listener - we will stop the bot and look around.
     */
    IWorldEventListener<GlobalChat> chatListener = new IWorldEventListener<GlobalChat>() {

        @Override
        public void notify(GlobalChat event) {
            if (!bDialogInProgress) {
                currentNavTarget = null;
                steering.stopNavigation();
                getAct().act(new Stop());
                if (!players.canSeePlayers()) {
                    Location focusLoc = info.getLocation().sub(info.getRotation().toLocation().getNormalized().scale(200));
                    getAct().act(new TurnTo().setLocation(focusLoc));

                    animations.playAnimation(AnimType.AMBI_LOOKAROUND01);
                    dialogPause.heat();
                } else {
                    getAct().act(new TurnTo().setLocation(players.getNearestVisiblePlayer().getLocation()));
                }
            }
        }
    };

    /**
     * Initialize all necessary variables here, before the bot actually receives anything
     * from the environment.
     */
    @Override
    public void prepareBot(UT2004Bot bot) {
        tabooPlayers = new TabooSet<Player>(bot);
        // By uncommenting following line, you can make the bot to do the file logging of all its components
        //bot.getLogger().addDefaultFileHandler(new File("EmptyBot.log"));
    }

    /**
     * Here we can modify initializing command for our bot, e.g., sets its name or skin.
     * @return instance of {@link Initialize}
     */
    @Override
    public Initialize getInitializeCommand() {
        return new Initialize().setName("EmohawkTwoBotsReacting").setClassName(CharacterType.THOMAS.getUE2Class());
    }

    /**
     * Handshake with GameBots2004 is over - bot has information about the map in its world view.
     * Many agent modules are usable since this method is called.
     * @param gameInfo informaton about the game type
     * @param config information about configuration
     * @param init information about configuration
     */
    @Override
    public void botInitialized(GameInfo gameInfo, ConfigChange currentConfig, InitedMessage init) {
    }

    /**
     * The bot is initilized in the environment - a physical representation of the bot is present in the game.
     * @param gameInfo informaton about the game type
     * @param config information about configuration
     * @param init information about configuration
     * @param self information about the agent
     */
    @Override
    public void botFirstSpawn(GameInfo gameInfo, ConfigChange config, InitedMessage init, Self self) {
        // Display a welcome message in the game engine
        // right in the time when the bot appears in the environment, i.e., his body has just been spawned
        // into the UT2004 for the first time.
        comm.sendGlobalTextMessage("Hello world! I am alive!");

        // alternatively, you may use getAct() method for issuing arbitrary {@link CommandMessage} for the bot's body
        // inside UT2004
        getAct().act(new SendMessage().setGlobal(true).setText("And I can speak! Hurray!"));
        //adding listener to bump message
        getWorldView().addEventListener(GlobalChat.class, chatListener);
    }

    /**
     * Main method that controls the bot - makes decisions what to do next.
     * It is called iteratively by Pogamut engine every time a synchronous batch
     * from the environment is received. This is usually 4 times per second - it
     * is affected by visionTime variable, that can be adjusted in GameBots ini file in
     * UT2004/System folder.
     *
     * @throws cz.cuni.amis.pogamut.base.exceptions.PogamutException
     */
    @Override
    public void logic() throws PogamutException {
        if (currentPlayerTarget != null && currentPlayerTarget.isVisible()) {
            if (info.atLocation(currentPlayerTarget.getLocation(), AT_LOC_THRESHOLD)) {
                if (!info.isMoving()) {
                    //speak to other bot
                    engageDialog();
                } else {
                    //stop the bot
                    steering.stopNavigation();
                    getAct().act(new Stop());
                    animations.playAnimation(AnimType.AMBI_STAND_NORMAL01, true);
                }
            } else if (dialogPause.isCool()) { //don't start moving if there is some dialog in progress!

                if (!steering.isNavigating()) {
                    steering.startNavigation();
                }
                if (!steering.isTargetApproachingActive()) {
                    steering.addTargetApproachingSteering(new TargetApproachingProperties(400, currentPlayerTarget.getLocation()));
                }
                if (!steering.isObstacleAvoidanceActive()) {
                    steering.addObstacleAvoidanceSteering(new ObstacleAvoidanceProperties());
                }
                if (steering.isPathFollowingActive()) {
                    steering.removePathFollowingSteering();
                }

                steering.setTargetApproachingSteering(new TargetApproachingProperties(400, currentPlayerTarget.getLocation()));
            }
        } else {
            Player pl = players.getNearestVisiblePlayer(tabooPlayers.filter(players.getVisiblePlayers().values()));
            if (pl != null) {
                currentPlayerTarget = pl;
                currentNavTarget = null;

                if (!greetedPlayers.contains((currentPlayerTarget.getId()))) {
                    //stop bot
                    steering.stopNavigation();
                    getAct().act(new Stop());
                    getAct().act(new TurnTo().setLocation(pl.getLocation()));
                    //greet player
                    animations.playAnimation(AnimType.SOCIAL_WAVENEAR);
                    emoticons.setCenterEmoticonType(EmoticonType.HI_213, 5, EmoticonBubbleType.BUBBLE_NORMAL_CENTER);
                    this.comm.sendGlobalTextMessage("Hi " + currentPlayerTarget.getName() + "!");
                    greetedPlayers.add((currentPlayerTarget).getId());
                    dialogPause.heat();
                }
                return;
            } else if (dialogPause.isCool()) {
                //walk randomly
                if (currentNavTarget == null) {
                    currentNavTarget = pickRandomNavPoint();
                }
                if (!info.atLocation(currentNavTarget, AT_LOC_THRESHOLD)) {
                    if (steering.isTargetApproachingActive()) {
                        steering.removeTargetApproachingSteering();
                    }
                    if (steering.isObstacleAvoidanceActive()) {
                        steering.removeObstacleAvoidanceSteering();
                    }
                    if (!steering.isPathFollowingActive()) {
                        steering.addPathFollowingSteering(new PathFollowingProperties(fwMap.computePath(getNearestNavPoint(), currentNavTarget)));
                    } else {
                        //we check if we have correct path set
                        if (steering.getPathFollowingProperties().getPath().getPathTo().getLocation().getDistance(currentNavTarget.getLocation()) > 50) {
                            steering.setPathFollowingSteering(new PathFollowingProperties(fwMap.computePath(getNearestNavPoint(), currentNavTarget)));
                        }
                    }

                    if (!steering.isNavigating()) {
                        steering.startNavigation();
                    }
                    currentNavTarget = null;
                }
            }
        }

        if (dialogPause.isCool() && info.isMoving() && (info.getSelf().getAnim() == null || !info.getSelf().getAnim().contains("walk_normal01"))) {
            animations.playAnimation(AnimType.WALK_NORMAL01, true);
        }
    }

    /**
     * Here we handle dialog with other agent.
     */
    private void engageDialog() {
        if (!bDialogInProgress) {
            bDialogInProgress = true;
            dialogStartTime = info.getTime(); //we want it in ms...
        }

        if (emoticonToReact != null) {
            //we have some emoticon to react to
            long currentTimeMs = Math.round(info.getTime() * 1000);
            if (currentTimeMs - emoticonToReact.getEmoticonSetTime() > randomReactionPause) {
                randomReactionPause = 2000 + new Random(System.currentTimeMillis()).nextInt(2000);
                if (emoticonToReact.getEmoticon().getCenterEmoticon() == EmoticonType.BYE_237) {
                    animations.playAnimation(AnimType.SOCIAL_WAVENEAR);
                    if (new Random(System.currentTimeMillis()).nextBoolean()) {
                        emoticons.setCenterEmoticonType(EmoticonType.BYE_237, 5, EmoticonBubbleType.BUBBLE_NORMAL_CENTER);
                    } else {
                        emoticons.setCenterEmoticonType(EmoticonType.OSEL_71, 5, EmoticonBubbleType.BUBBLE_THOUGHT_CENTER);
                    }
                    finishDialog();
                    //store the time of our reaction here
                    lastCurPlayerEmoticonResponseTime = Math.round(info.getTime() * 1000);
                    //heatup our dialog pause - we have spoken recently
                    dialogPause.heat();
                } else if (emoticonToReact.getEmoticon().getCenterEmoticon() == EmoticonType.SCHOOL_207) {
                    animations.playAnimation(AnimType.SOCIAL_EXPLAIN);
                    emoticons.setCenterEmoticonType(EmoticonType.F_210, 5, EmoticonBubbleType.BUBBLE_NORMAL_CENTER);
                    //store the time of our reaction here
                    lastCurPlayerEmoticonResponseTime = Math.round(info.getTime() * 1000);
                    //heatup our dialog pause - we have spoken recently
                    dialogPause.heat();
                } else if (emoticonToReact.getEmoticon().getCenterEmoticon() == EmoticonType.F_210) {
                    animations.playAnimation(AnimType.SOCIAL_ENTHUSE);
                    emoticons.setCenterEmoticonType(EmoticonType.NASTY_OLD_TEACHER_65, 5, EmoticonBubbleType.BUBBLE_NORMAL_CENTER);
                    //store the time of our reaction here
                    lastCurPlayerEmoticonResponseTime = Math.round(info.getTime() * 1000);
                    //heatup our dialog pause - we have spoken recently
                    dialogPause.heat();
                } else if (emoticonToReact.getEmoticon().getCenterEmoticon() == EmoticonType.BEER_82) {
                    animations.playAnimation(AnimType.SOCIAL_DISAGREE);
                    emoticons.setCenterEmoticonType(EmoticonType.GLASS_OF_WINE_100, 5, EmoticonBubbleType.BUBBLE_NORMAL_CENTER);
                    //store the time of our reaction here
                    lastCurPlayerEmoticonResponseTime = Math.round(info.getTime() * 1000);
                    //heatup our dialog pause - we have spoken recently
                    dialogPause.heat();
                } else if (emoticonToReact.getEmoticon().getCenterEmoticon() == EmoticonType.GLASS_OF_WINE_100) {
                    animations.playAnimation(AnimType.SOCIAL_ENTHUSE);
                    emoticons.setCenterEmoticonType(EmoticonType.GLASS_OF_JUICE_99, 5, EmoticonBubbleType.BUBBLE_NORMAL_CENTER);
                    //store the time of our reaction here
                    lastCurPlayerEmoticonResponseTime = Math.round(info.getTime() * 1000);
                    //heatup our dialog pause - we have spoken recently
                    dialogPause.heat();
                }

                //emoticon was processed - we store info about it
                previousEmoticonToReact = emoticonToReact;
                emoticonToReact = null;
            }
        } else {
            if ((emoticons.getPlayerEmoticonInfo(currentPlayerTarget.getId()).getEmoticonSetTime() > lastCurPlayerEmoticonResponseTime) && previousEmoticonToReact != emoticons.getPlayerEmoticonInfo(currentPlayerTarget.getId())) {
                //check if there is a new emoticon for us to resolve that has not been resolved before
                emoticonToReact = emoticons.getPlayerEmoticonInfo(currentPlayerTarget.getId());
            } else {
                //nothing to respond to, pick something ourselves
                if (dialogPause.isCool()) {
                    if (info.getTime() - dialogStartTime >= DIALOG_TIMEOUT) {
                        animations.playAnimation(AnimType.SOCIAL_WAVENEAR);
                        emoticons.setCenterEmoticonType(EmoticonType.BYE_237, 5, EmoticonBubbleType.BUBBLE_NORMAL_CENTER);
                        lastCurPlayerEmoticonResponseTime = Math.round(info.getTime() * 1000);
                        dialogPause.heat();

                        finishDialog();
                    } else {
                        //or pick something at random
                        if (new Random(System.currentTimeMillis()).nextBoolean()) {
                            emoticons.setCenterEmoticonType(EmoticonType.SCHOOL_207, 5, EmoticonBubbleType.BUBBLE_NORMAL_CENTER);
                        } else {
                            emoticons.setCenterEmoticonType(EmoticonType.BEER_82, 5, EmoticonBubbleType.BUBBLE_NORMAL_CENTER);
                        }
                        animations.playAnimation(AnimType.SOCIAL_EXPLAIN);
                        lastCurPlayerEmoticonResponseTime = Math.round(info.getTime() * 1000);
                        dialogPause.heat();
                    }
                }
            }
        }

    }

    /**
     * Finish the dialog - set properly all vars.
     */
    private void finishDialog() {
        //finishing dialog
        tabooPlayers.add(currentPlayerTarget, NO_DIALOG_TIMEOUT);
        greetedPlayers.remove(currentPlayerTarget.getId());
        bDialogInProgress = false;
        currentPlayerTarget = null;
    }

    /**
     * Called each time the bot dies. Good for reseting all bot's state dependent variables.
     *
     * @param event
     */
    @Override
    public void botKilled(BotKilled event) {
        // First, try to run the bot and kill it... than uncomment this line and run the bot again
        // kill it and see the difference.
        //body.getCommunication().sendGlobalTextMessage("I was KILLED!");
    }

    /**
     * This method is called when the bot is started either from IDE or from command line.
     *
     * @param args
     */
    public static void main(String args[]) throws PogamutException {
        // wrapped logic for bots executions, suitable to run single bot in single JVM
        new UT2004BotRunner(EmohawkTwoBotsReacting.class, "EmohawkTwoBotsReacting").setHost("localhost").setPort(3000).setMain(true).startAgent();
    }

    /**
     * Picks one NavPoint at random.
     * @return
     */
    private NavPoint pickRandomNavPoint() {
        Collection<NavPoint> navPoints = getWorldView().getAll(NavPoint.class).values();
        int ranInt = new Random(System.currentTimeMillis()).nextInt(navPoints.size());

        NavPoint result = (NavPoint) navPoints.toArray()[ranInt];

        return result;
    }

    /**
     * Gets nearest NavPoint to our location.
     * @return
     */
    private NavPoint getNearestNavPoint() {
        NavPoint result = null;
        for (NavPoint navPoint : getWorldView().getAll(NavPoint.class).values()) {
            if (result == null || info.getLocation().getDistance(navPoint.getLocation()) < info.getLocation().getDistance(result.getLocation())) {
                result = navPoint;
            }
        }

        return result;
    }
}
