/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.emohawk.examples.twobots;

import SteeringProperties.ObstacleAvoidanceProperties;
import SteeringProperties.PathFollowingProperties;
import SteeringProperties.TargetApproachingProperties;
import cz.cuni.amis.pogamut.base.communication.messages.CommandMessage;
import cz.cuni.amis.pogamut.base.communication.worldview.event.IWorldEventListener;
import cz.cuni.amis.pogamut.base.utils.guice.AgentScoped;
import cz.cuni.amis.pogamut.base3d.worldview.object.ILocated;
import cz.cuni.amis.pogamut.base3d.worldview.object.Location;
import cz.cuni.amis.pogamut.emohawk.agent.module.sensomotoric.AnimType;
import cz.cuni.amis.pogamut.emohawk.agent.module.sensomotoric.CharacterType;
import cz.cuni.amis.pogamut.emohawk.agent.module.sensomotoric.EmoticonBubbleType;
import cz.cuni.amis.pogamut.emohawk.agent.module.sensomotoric.EmoticonInfo;
import cz.cuni.amis.pogamut.emohawk.agent.module.sensomotoric.EmoticonType;
import cz.cuni.amis.pogamut.emohawk.bot.impl.EmohawkBotController;
import cz.cuni.amis.pogamut.unreal.communication.messages.UnrealId;
import cz.cuni.amis.pogamut.ut2004.agent.module.utils.TabooSet;
import cz.cuni.amis.pogamut.ut2004.bot.impl.UT2004Bot;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbcommands.Initialize;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbcommands.SendMessage;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbcommands.Stop;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbcommands.TurnTo;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.BotKilled;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.ConfigChange;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.GameInfo;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.GlobalChat;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.InitedMessage;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.NavPoint;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.Player;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.Self;
import cz.cuni.amis.pogamut.ut2004.utils.UT2004BotRunner;
import cz.cuni.amis.utils.Heatup;
import cz.cuni.amis.utils.exception.PogamutException;
import java.util.Collection;
import java.util.HashSet;
import java.util.Random;

@AgentScoped
public class EmohawkTwoBotsReacting
extends EmohawkBotController {
    Heatup dialogPause = new Heatup(6000L);
    boolean bDialogInProgress = false;
    double dialogStartTime = 0.0;
    Heatup bumpResponsePause = new Heatup(6000L);
    HashSet<UnrealId> greetedPlayers = new HashSet();
    Player currentPlayerTarget = null;
    long lastCurPlayerEmoticonResponseTime = 0L;
    EmoticonInfo emoticonToReact = null;
    EmoticonInfo previousEmoticonToReact = null;
    NavPoint currentNavTarget = null;
    private static final int AT_LOC_THRESHOLD = 300;
    TabooSet<Player> tabooPlayers;
    private static final int DIALOG_TIMEOUT = 30;
    private static final int NO_DIALOG_TIMEOUT = 60;
    int randomReactionPause = 2000 + new Random(System.currentTimeMillis()).nextInt(2000);
    IWorldEventListener<GlobalChat> chatListener = new IWorldEventListener<GlobalChat>(){

        public void notify(GlobalChat event) {
            if (!EmohawkTwoBotsReacting.this.bDialogInProgress) {
                EmohawkTwoBotsReacting.this.currentNavTarget = null;
                EmohawkTwoBotsReacting.this.steering.stopNavigation();
                EmohawkTwoBotsReacting.this.getAct().act((CommandMessage)new Stop());
                if (!EmohawkTwoBotsReacting.this.players.canSeePlayers()) {
                    Location focusLoc = EmohawkTwoBotsReacting.this.info.getLocation().sub(EmohawkTwoBotsReacting.this.info.getRotation().toLocation().getNormalized().scale(200.0));
                    EmohawkTwoBotsReacting.this.getAct().act((CommandMessage)new TurnTo().setLocation(focusLoc));
                    EmohawkTwoBotsReacting.this.animations.playAnimation(AnimType.AMBI_LOOKAROUND01);
                    EmohawkTwoBotsReacting.this.dialogPause.heat();
                } else {
                    EmohawkTwoBotsReacting.this.getAct().act((CommandMessage)new TurnTo().setLocation(EmohawkTwoBotsReacting.this.players.getNearestVisiblePlayer().getLocation()));
                }
            }
        }
    };

    public void prepareBot(UT2004Bot bot) {
        this.tabooPlayers = new TabooSet(bot);
    }

    public Initialize getInitializeCommand() {
        return new Initialize().setName("EmohawkTwoBotsReacting").setClassName(CharacterType.THOMAS.getUE2Class());
    }

    public void botInitialized(GameInfo gameInfo, ConfigChange currentConfig, InitedMessage init) {
    }

    public void botSpawned(GameInfo gameInfo, ConfigChange config, InitedMessage init, Self self) {
        this.comm.sendGlobalTextMessage("Hello world! I am alive!");
        this.getAct().act((CommandMessage)new SendMessage().setGlobal(Boolean.valueOf(true)).setText("And I can speak! Hurray!"));
        this.getWorldView().addEventListener(GlobalChat.class, this.chatListener);
    }

    public void logic() throws PogamutException {
        if (this.currentPlayerTarget != null && this.currentPlayerTarget.isVisible()) {
            if (this.info.atLocation((ILocated)this.currentPlayerTarget.getLocation(), 300.0)) {
                if (!this.info.isMoving().booleanValue()) {
                    this.engageDialog();
                } else {
                    this.steering.stopNavigation();
                    this.getAct().act((CommandMessage)new Stop());
                    this.animations.playAnimation(AnimType.AMBI_STAND_NORMAL01, true);
                }
            } else if (this.dialogPause.isCool()) {
                if (!this.steering.isNavigating()) {
                    this.steering.startNavigation();
                }
                if (!this.steering.isTargetApproachingActive()) {
                    this.steering.addTargetApproachingSteering(new TargetApproachingProperties(400, this.currentPlayerTarget.getLocation()));
                }
                if (!this.steering.isObstacleAvoidanceActive()) {
                    this.steering.addObstacleAvoidanceSteering(new ObstacleAvoidanceProperties());
                }
                if (this.steering.isPathFollowingActive()) {
                    this.steering.removePathFollowingSteering();
                }
                this.steering.setTargetApproachingSteering(new TargetApproachingProperties(400, this.currentPlayerTarget.getLocation()));
            }
        } else {
            Player pl = this.players.getNearestVisiblePlayer((Collection)this.tabooPlayers.filter(this.players.getVisiblePlayers().values()));
            if (pl != null) {
                this.currentPlayerTarget = pl;
                this.currentNavTarget = null;
                if (!this.greetedPlayers.contains(this.currentPlayerTarget.getId())) {
                    this.steering.stopNavigation();
                    this.getAct().act((CommandMessage)new Stop());
                    this.getAct().act((CommandMessage)new TurnTo().setLocation(pl.getLocation()));
                    this.animations.playAnimation(AnimType.SOCIAL_WAVENEAR);
                    this.emoticons.setCenterEmoticonType(EmoticonType.HI_213, 5.0, EmoticonBubbleType.BUBBLE_NORMAL_CENTER);
                    this.comm.sendGlobalTextMessage("Hi " + this.currentPlayerTarget.getName() + "!");
                    this.greetedPlayers.add(this.currentPlayerTarget.getId());
                    this.dialogPause.heat();
                }
                return;
            }
            if (this.dialogPause.isCool()) {
                if (this.currentNavTarget == null) {
                    this.currentNavTarget = this.pickRandomNavPoint();
                }
                if (!this.info.atLocation((ILocated)this.currentNavTarget, 300.0)) {
                    if (this.steering.isTargetApproachingActive()) {
                        this.steering.removeTargetApproachingSteering();
                    }
                    if (this.steering.isObstacleAvoidanceActive()) {
                        this.steering.removeObstacleAvoidanceSteering();
                    }
                    if (!this.steering.isPathFollowingActive()) {
                        this.steering.addPathFollowingSteering(new PathFollowingProperties(this.fwMap.computePath(this.getNearestNavPoint(), this.currentNavTarget)));
                    } else if (((ILocated)this.steering.getPathFollowingProperties().getPath().getPathTo()).getLocation().getDistance(this.currentNavTarget.getLocation()) > 50.0) {
                        this.steering.setPathFollowingSteering(new PathFollowingProperties(this.fwMap.computePath(this.getNearestNavPoint(), this.currentNavTarget)));
                    }
                    if (!this.steering.isNavigating()) {
                        this.steering.startNavigation();
                    }
                    this.currentNavTarget = null;
                }
            }
        }
        if (this.dialogPause.isCool() && this.info.isMoving().booleanValue() && (this.info.getSelf().getAnim() == null || !this.info.getSelf().getAnim().contains("walk_normal01"))) {
            this.animations.playAnimation(AnimType.WALK_NORMAL01, true);
        }
    }

    private void engageDialog() {
        if (!this.bDialogInProgress) {
            this.bDialogInProgress = true;
            this.dialogStartTime = this.info.getTime();
        }
        if (this.emoticonToReact != null) {
            long currentTimeMs = Math.round(this.info.getTime() * 1000.0);
            if (currentTimeMs - this.emoticonToReact.getEmoticonSetTime() > (long)this.randomReactionPause) {
                this.randomReactionPause = 2000 + new Random(System.currentTimeMillis()).nextInt(2000);
                if (this.emoticonToReact.getEmoticon().getCenterEmoticon() == EmoticonType.BYE_237) {
                    this.animations.playAnimation(AnimType.SOCIAL_WAVENEAR);
                    if (new Random(System.currentTimeMillis()).nextBoolean()) {
                        this.emoticons.setCenterEmoticonType(EmoticonType.BYE_237, 5.0, EmoticonBubbleType.BUBBLE_NORMAL_CENTER);
                    } else {
                        this.emoticons.setCenterEmoticonType(EmoticonType.OSEL_71, 5.0, EmoticonBubbleType.BUBBLE_THOUGHT_CENTER);
                    }
                    this.finishDialog();
                    this.lastCurPlayerEmoticonResponseTime = Math.round(this.info.getTime() * 1000.0);
                    this.dialogPause.heat();
                } else if (this.emoticonToReact.getEmoticon().getCenterEmoticon() == EmoticonType.SCHOOL_207) {
                    this.animations.playAnimation(AnimType.SOCIAL_EXPLAIN);
                    this.emoticons.setCenterEmoticonType(EmoticonType.F_210, 5.0, EmoticonBubbleType.BUBBLE_NORMAL_CENTER);
                    this.lastCurPlayerEmoticonResponseTime = Math.round(this.info.getTime() * 1000.0);
                    this.dialogPause.heat();
                } else if (this.emoticonToReact.getEmoticon().getCenterEmoticon() == EmoticonType.F_210) {
                    this.animations.playAnimation(AnimType.SOCIAL_ENTHUSE);
                    this.emoticons.setCenterEmoticonType(EmoticonType.NASTY_OLD_TEACHER_65, 5.0, EmoticonBubbleType.BUBBLE_NORMAL_CENTER);
                    this.lastCurPlayerEmoticonResponseTime = Math.round(this.info.getTime() * 1000.0);
                    this.dialogPause.heat();
                } else if (this.emoticonToReact.getEmoticon().getCenterEmoticon() == EmoticonType.BEER_82) {
                    this.animations.playAnimation(AnimType.SOCIAL_DISAGREE);
                    this.emoticons.setCenterEmoticonType(EmoticonType.GLASS_OF_WINE_100, 5.0, EmoticonBubbleType.BUBBLE_NORMAL_CENTER);
                    this.lastCurPlayerEmoticonResponseTime = Math.round(this.info.getTime() * 1000.0);
                    this.dialogPause.heat();
                } else if (this.emoticonToReact.getEmoticon().getCenterEmoticon() == EmoticonType.GLASS_OF_WINE_100) {
                    this.animations.playAnimation(AnimType.SOCIAL_ENTHUSE);
                    this.emoticons.setCenterEmoticonType(EmoticonType.GLASS_OF_JUICE_99, 5.0, EmoticonBubbleType.BUBBLE_NORMAL_CENTER);
                    this.lastCurPlayerEmoticonResponseTime = Math.round(this.info.getTime() * 1000.0);
                    this.dialogPause.heat();
                }
                this.previousEmoticonToReact = this.emoticonToReact;
                this.emoticonToReact = null;
            }
        } else if (this.emoticons.getPlayerEmoticonInfo(this.currentPlayerTarget.getId()).getEmoticonSetTime() > this.lastCurPlayerEmoticonResponseTime && this.previousEmoticonToReact != this.emoticons.getPlayerEmoticonInfo(this.currentPlayerTarget.getId())) {
            this.emoticonToReact = this.emoticons.getPlayerEmoticonInfo(this.currentPlayerTarget.getId());
        } else if (this.dialogPause.isCool()) {
            if (this.info.getTime() - this.dialogStartTime >= 30.0) {
                this.animations.playAnimation(AnimType.SOCIAL_WAVENEAR);
                this.emoticons.setCenterEmoticonType(EmoticonType.BYE_237, 5.0, EmoticonBubbleType.BUBBLE_NORMAL_CENTER);
                this.lastCurPlayerEmoticonResponseTime = Math.round(this.info.getTime() * 1000.0);
                this.dialogPause.heat();
                this.finishDialog();
            } else {
                if (new Random(System.currentTimeMillis()).nextBoolean()) {
                    this.emoticons.setCenterEmoticonType(EmoticonType.SCHOOL_207, 5.0, EmoticonBubbleType.BUBBLE_NORMAL_CENTER);
                } else {
                    this.emoticons.setCenterEmoticonType(EmoticonType.BEER_82, 5.0, EmoticonBubbleType.BUBBLE_NORMAL_CENTER);
                }
                this.animations.playAnimation(AnimType.SOCIAL_EXPLAIN);
                this.lastCurPlayerEmoticonResponseTime = Math.round(this.info.getTime() * 1000.0);
                this.dialogPause.heat();
            }
        }
    }

    private void finishDialog() {
        this.tabooPlayers.add((Object)this.currentPlayerTarget, 60.0);
        this.greetedPlayers.remove(this.currentPlayerTarget.getId());
        this.bDialogInProgress = false;
        this.currentPlayerTarget = null;
    }

    public void botKilled(BotKilled event) {
    }

    public static void main(String[] args) throws PogamutException {
        new UT2004BotRunner(EmohawkTwoBotsReacting.class, "EmohawkTwoBotsReacting").setHost("localhost").setPort(3000).setMain(true).startAgent();
    }

    private NavPoint pickRandomNavPoint() {
        Collection navPoints = this.getWorldView().getAll(NavPoint.class).values();
        int ranInt = new Random(System.currentTimeMillis()).nextInt(navPoints.size());
        NavPoint result = (NavPoint)navPoints.toArray()[ranInt];
        return result;
    }

    private NavPoint getNearestNavPoint() {
        NavPoint result = null;
        for (NavPoint navPoint : this.getWorldView().getAll(NavPoint.class).values()) {
            if (result != null && !(this.info.getLocation().getDistance(navPoint.getLocation()) < this.info.getLocation().getDistance(result.getLocation()))) continue;
            result = navPoint;
        }
        return result;
    }
}

