package cz.cuni.amis.pogamut.defcon.jason.action;


import jason.asSemantics.DefaultInternalAction;
import jason.asSemantics.TransitionSystem;
import jason.asSemantics.Unifier;
import jason.asSyntax.Term;
import cz.cuni.amis.pogamut.defcon.jason.arch.GeneralAgArch;
import cz.cuni.amis.pogamut.defcon.jason.mainai.IJasonAI;

/**
 * Super-class for all Defcon internal classes.
 * 
 * @author Radek 'Black_Hand' Pibil
 * 
 */
public abstract class AbstractInternalAction extends DefaultInternalAction {

	public IJasonAI getAgent(TransitionSystem ts)
			throws IllegalArgumentException {
		if (ts.getUserAgArch() instanceof GeneralAgArch) {
			return ((GeneralAgArch) ts.getUserAgArch()).getAgent();
		} else {
			throw new IllegalArgumentException("Illegal Architecture Class");
		}
	}

	@Override
	public Object execute(TransitionSystem ts, Unifier un, Term[] args)
			throws Exception {
		try {
			return executeWorker(ts, un, args);
		} catch (InterruptedException e) {
			return false;
		}
	}

	protected abstract Object executeWorker(TransitionSystem ts, Unifier un,
			Term[] args) throws Exception;
}
