/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.defcon.jason;

import jason.asSyntax.directives.DirectiveProcessor;
import jason.asSyntax.directives.Include;
import jason.infra.centralised.CentralisedAgArch;
import jason.infra.centralised.RunCentralisedMAS;
import jason.jeditplugin.Config;
import jason.mas2j.MAS2JProject;
import jason.mas2j.parser.ParseException;
import jason.mas2j.parser.mas2j;
import jason.runtime.MASConsoleGUI;
import jason.runtime.MASConsoleLogHandler;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.net.URL;
import java.util.Map;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.Logger;
import javax.swing.JOptionPane;

public class RunDefConCentralisedMAS
extends RunCentralisedMAS {
    protected static Logger logger = Logger.getLogger(RunDefConCentralisedMAS.class.getName());
    protected static MAS2JProject project;
    protected static String urlPrefix;
    protected boolean debug = false;
    protected final int poolSize;
    protected Field myThreadField;

    public RunDefConCentralisedMAS(boolean debug, int poolSize) {
        runner = this;
        this.debug = debug;
        this.poolSize = poolSize;
        this.initFields();
    }

    public void init() {
        this.init(null);
    }

    protected void initFields() {
        try {
            Field loggerField = RunCentralisedMAS.class.getDeclaredField("logger");
            loggerField.setAccessible(true);
            loggerField.set(null, logger);
            loggerField.setAccessible(false);
            Field debugField = RunCentralisedMAS.class.getDeclaredField("debug");
            debugField.setAccessible(true);
            debugField.set((Object)this, this.debug);
            debugField.setAccessible(false);
            this.myThreadField = CentralisedAgArch.class.getDeclaredField("myThread");
            this.myThreadField.setAccessible(true);
        }
        catch (Exception e) {
            System.err.println("Invalid field? " + e.toString());
            e.printStackTrace();
        }
    }

    protected void setProject(MAS2JProject project) {
        try {
            Field projectField = RunCentralisedMAS.class.getDeclaredField("project");
            projectField.setAccessible(true);
            projectField.set(null, project);
            projectField.setAccessible(false);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void setURLPrefix(String urlPrefix) {
        try {
            RunDefConCentralisedMAS.urlPrefix = urlPrefix;
            Field projectField = RunCentralisedMAS.class.getDeclaredField("urlPrefix");
            projectField.setAccessible(true);
            projectField.set(null, urlPrefix);
            projectField.setAccessible(false);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void init(String[] args) {
        String projectFileName = null;
        if (RunCentralisedMAS.class.getResource("/default.mas2j") != null) {
            projectFileName = "default.mas2j";
            Config.get((boolean)false);
        } else {
            System.out.println("Jason " + Config.get().getJasonRunningVersion());
            System.err.println("You should inform the MAS project file.");
            JOptionPane.showMessageDialog(null, "Jason version " + Config.get().getJasonRunningVersion() + " library built on " + Config.get().getJasonBuiltDate(), "Jason", 1);
            System.exit(0);
        }
        RunDefConCentralisedMAS.setupLogger();
        for (Handler h : Logger.getLogger("").getHandlers()) {
            if (!h.getClass().toString().equals(MASConsoleLogHandler.class.toString())) continue;
            MASConsoleGUI.get().getFrame().setVisible(true);
            MASConsoleGUI.get().setAsDefaultOut();
        }
        int errorCode = 0;
        try {
            InputStream inProject = RunCentralisedMAS.class.getResource("/default.mas2j").openStream();
            this.setURLPrefix("ClassResource:/");
            mas2j parser = new mas2j(inProject);
            project = parser.mas();
            project.setupDefault();
            project.registerDirectives();
            this.setProject(project);
            ((Include)DirectiveProcessor.getDirective((String)"include")).setSourcePath(project.getSourcePaths());
            super.createAgs(project, this.debug);
            super.startAgs();
            for (CentralisedAgArch ag : this.getAgs().values()) {
                this.setAgArchThreadPriority(ag, 3);
            }
            super.startSyncMode();
            if (MASConsoleGUI.hasConsole()) {
                MASConsoleGUI.get().setTitle("MAS Console - " + project.getSocName());
                this.createButtons();
            }
            super.waitEnd();
            errorCode = 0;
        }
        catch (FileNotFoundException e1) {
            logger.log(Level.SEVERE, "File " + projectFileName + " not found!");
            errorCode = 2;
        }
        catch (ParseException e) {
            logger.log(Level.SEVERE, "Error parsing file " + projectFileName + "!", e);
            errorCode = 3;
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Error!?: ", e);
            errorCode = 4;
        }
        System.out.flush();
        System.err.flush();
        if (!MASConsoleGUI.hasConsole() && errorCode != 0) {
            System.exit(errorCode);
        }
    }

    public void setAgArchThreadPriority(CentralisedAgArch ag, int priority) {
        try {
            Thread myThread = (Thread)this.myThreadField.get(ag);
            myThread.setPriority(priority);
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
    }

    public static synchronized void setupLogger() {
        try {
            URL res = RunDefConCentralisedMAS.class.getResource("/logging.properties");
            System.out.println("Setting up logger:" + res);
            LogManager.getLogManager().readConfiguration(res.openStream());
        }
        catch (Exception e) {
            System.err.println("Error setting up logger:" + e.getMessage());
            e.printStackTrace();
        }
    }

    public static RunDefConCentralisedMAS getRunner() {
        return (RunDefConCentralisedMAS)runner;
    }

    public Map<String, CentralisedAgArch> getAgs() {
        return super.getAgs();
    }

    static {
        urlPrefix = "";
    }
}

