package cz.cuni.amis.pogamut.defcon.jason.action;

import static jason.asSyntax.ASSyntax.createNumber;
import jason.asSemantics.TransitionSystem;
import jason.asSemantics.Unifier;
import jason.asSyntax.NumberTerm;
import jason.asSyntax.Term;
import cz.cuni.amis.pogamut.defcon.jason.mainai.IJasonAI;

/**
 * Returns the current time.
 * 
 * @author Radek 'Black_Hand' Pibil
 * 
 */
public class time extends AbstractInternalAction {

    @Override
	public Object executeWorker(TransitionSystem ts, Unifier un, Term[] args)
			throws Exception {

		// ts.getAg().getLogger()
		// .info("executing internal action 'time'");
		final IJasonAI agent = getAgent(ts);
		if (agent == null)
			return false;

		if (args.length != 1) {
			return false;
		}
		
		NumberTerm timeTerm = (NumberTerm) args[0];

		int gameTick = agent.getGameInfo()
				.getGameTick();

		return un.unifies(timeTerm, createNumber(gameTick));
    }
}
