package cz.cuni.amis.pogamut.defcon.jason.action;

import static jason.asSyntax.ASSyntax.createString;
import jason.asSemantics.TransitionSystem;
import jason.asSemantics.Unifier;
import jason.asSyntax.NumberTerm;
import jason.asSyntax.StringTerm;
import jason.asSyntax.Term;
import cz.cuni.amis.pogamut.base.communication.worldview.object.WorldObjectId;
import cz.cuni.amis.pogamut.defcon.communication.messages.infos.DefConUnitObject;
import cz.cuni.amis.pogamut.defcon.jason.mainai.IJasonAI;

/**
 * Returns the unit's anti-submarine state.
 * 
 * @author Radek 'Black_Hand' Pibil
 * 
 */
public class antiSubState extends AbstractInternalAction {

    @Override
	public Object executeWorker(TransitionSystem ts, Unifier un, Term[] args)
			throws Exception {

		// ts.getAg().getLogger().info("executing internal action 'antiSubState'");

		final IJasonAI agent = getAgent(ts);
		if (agent == null)
			return false;

		if (args.length != 2) {
			return false;
		}

		NumberTerm unitIdTerm = (NumberTerm) args[0];
		StringTerm stateTerm = (StringTerm) args[1];

		if (!unitIdTerm.isGround() || !stateTerm.isVar()) {
			return false;
		}

		int unitId = new Double(unitIdTerm.solve()).intValue();

		DefConUnitObject<?> unit = (DefConUnitObject<?>) agent.getWorldView()
				.get(WorldObjectId.get(unitId));

		if (unit == null || unit.getType() == null)
			return false;

		DefConUnitObject<?> object = (DefConUnitObject<?>) agent.getWorldView()
				.get(WorldObjectId.get(unitId));

		switch (object.getType()) {
			case CARRIER: {
				return un.unifies(
						stateTerm,
						createString("ANTISUB"));
			}
			case SUB: {
				return un.unifies(
						stateTerm,
						createString("ACTIVE_SONAR"));
			}
		}

		return false;
    }
}
